/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.util.IdUtil;

public class JarUtil {
    private LanguageConnectionContext lcc;
    private String schemaName;
    private String sqlName;
    private FileResource fr;
    private DataDictionary dd;
    private DataDescriptorGenerator ddg;

    private JarUtil(LanguageConnectionContext lcc, String schemaName, String sqlName) throws StandardException {
        this.schemaName = schemaName;
        this.sqlName = sqlName;
        this.lcc = lcc;
        this.fr = lcc.getTransactionExecute().getFileHandler();
        this.dd = lcc.getDataDictionary();
        this.ddg = this.dd.getDataDescriptorGenerator();
    }

    public static long install(LanguageConnectionContext lcc, String schemaName, String sqlName, String externalPath) throws StandardException {
        JarUtil jutil = new JarUtil(lcc, schemaName, sqlName);
        InputStream is = null;
        try {
            is = JarUtil.openJarURL(externalPath);
            long l = jutil.add(is);
            return l;
        }
        catch (IOException fnfe) {
            throw StandardException.newException("46001", fnfe, (Object)externalPath);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long add(InputStream is) throws StandardException {
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fid = this.getInfo();
        if (fid != null) {
            throw StandardException.newException("X0Y32.S", fid.getDescriptorType(), (Object)this.sqlName, (Object)fid.getSchemaDescriptor().getDescriptorType(), (Object)this.schemaName);
        }
        SchemaDescriptor sd = this.dd.getSchemaDescriptor(this.schemaName, null, true);
        try {
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            String jarExternalName = JarUtil.mkExternalName(this.schemaName, this.sqlName, this.fr.getSeparatorChar());
            long generationId = this.setJar(jarExternalName, is, true, 0L);
            fid = this.ddg.newFileInfoDescriptor(null, sd, this.sqlName, generationId);
            this.dd.addDescriptor(fid, sd, 12, false, this.lcc.getTransactionExecute());
            long l = generationId;
            return l;
        }
        finally {
            this.notifyLoader(true);
        }
    }

    public static void drop(LanguageConnectionContext lcc, String schemaName, String sqlName) throws StandardException {
        JarUtil jutil = new JarUtil(lcc, schemaName, sqlName);
        jutil.drop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drop() throws StandardException {
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fid = this.getInfo();
        if (fid == null) {
            throw StandardException.newException("X0X13.S", (Object)this.sqlName, (Object)this.schemaName);
        }
        String dbcp_s = PropertyUtil.getServiceProperty(this.lcc.getTransactionExecute(), "derby.database.classpath");
        if (dbcp_s != null) {
            String[][] dbcp = IdUtil.parseDbClassPath(dbcp_s);
            boolean found = false;
            for (int ix = 0; ix < dbcp.length; ++ix) {
                if (dbcp.length != 2 || !dbcp[ix][0].equals(this.schemaName) || !dbcp[ix][1].equals(this.sqlName)) continue;
                found = true;
            }
            if (found) {
                throw StandardException.newException("X0X07.S", (Object)IdUtil.mkQualifiedName(this.schemaName, this.sqlName), (Object)dbcp_s);
            }
        }
        try {
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            DependencyManager dm = this.dd.getDependencyManager();
            dm.invalidateFor(fid, 17, this.lcc);
            this.dd.dropFileInfoDescriptor(fid);
            this.fr.remove(JarUtil.mkExternalName(this.schemaName, this.sqlName, this.fr.getSeparatorChar()), fid.getGenerationId());
        }
        finally {
            this.notifyLoader(true);
        }
    }

    public static long replace(LanguageConnectionContext lcc, String schemaName, String sqlName, String externalPath) throws StandardException {
        JarUtil jutil = new JarUtil(lcc, schemaName, sqlName);
        InputStream is = null;
        try {
            is = JarUtil.openJarURL(externalPath);
            long l = jutil.replace(is);
            return l;
        }
        catch (IOException fnfe) {
            throw StandardException.newException("46001", fnfe, (Object)externalPath);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long replace(InputStream is) throws StandardException {
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fid = this.getInfo();
        if (fid == null) {
            throw StandardException.newException("X0X13.S", (Object)this.sqlName, (Object)this.schemaName);
        }
        try {
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            this.dd.dropFileInfoDescriptor(fid);
            String jarExternalName = JarUtil.mkExternalName(this.schemaName, this.sqlName, this.fr.getSeparatorChar());
            long generationId = this.setJar(jarExternalName, is, false, fid.getGenerationId());
            FileInfoDescriptor fid2 = this.ddg.newFileInfoDescriptor(fid.getUUID(), fid.getSchemaDescriptor(), this.sqlName, generationId);
            this.dd.addDescriptor(fid2, fid.getSchemaDescriptor(), 12, false, this.lcc.getTransactionExecute());
            long l = generationId;
            return l;
        }
        finally {
            this.notifyLoader(true);
        }
    }

    private FileInfoDescriptor getInfo() throws StandardException {
        SchemaDescriptor sd = this.dd.getSchemaDescriptor(this.schemaName, null, true);
        return this.dd.getFileInfoDescriptor(sd, this.sqlName);
    }

    private void notifyLoader(boolean reload) throws StandardException {
        ClassFactory cf = this.lcc.getLanguageConnectionFactory().getClassFactory();
        cf.notifyModifyJar(reload);
    }

    private static InputStream openJarURL(final String externalPath) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    try {
                        return new URL(externalPath).openStream();
                    }
                    catch (MalformedURLException mfurle) {
                        return new FileInputStream(externalPath);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private long setJar(final String jarExternalName, final InputStream contents, final boolean add, final long currentGenerationId) throws StandardException {
        try {
            return (Long)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws StandardException {
                    long generationId = add ? JarUtil.this.fr.add(jarExternalName, contents) : JarUtil.this.fr.replace(jarExternalName, currentGenerationId, contents);
                    return new Long(generationId);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (StandardException)e.getException();
        }
    }

    public static String mkExternalName(String schemaName, String sqlName, char separatorChar) {
        StringBuffer sb = new StringBuffer(30);
        sb.append("jar");
        sb.append(separatorChar);
        sb.append(schemaName);
        sb.append(separatorChar);
        sb.append(sqlName);
        sb.append(".jar");
        return sb.toString();
    }
}

