/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.net.ServerSocketFactory;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.replication.net.ReplicationMessage;
import org.apache.derby.impl.store.replication.net.SlaveAddress;
import org.apache.derby.impl.store.replication.net.SocketConnection;

public class ReplicationMessageReceive {
    private final SlaveAddress slaveAddress;
    private ServerSocket serverSocket;
    private SocketConnection socketConn;
    private static final int DEFAULT_PING_TIMEOUT = 5000;
    private Thread pingThread = null;
    private boolean killPingThread = false;
    private boolean connectionConfirmed = false;
    private final Object sendPingSemaphore = new Object();
    private final Object receivePongSemaphore = new Object();

    public ReplicationMessageReceive(SlaveAddress slaveAddress, String dbname) {
        this.slaveAddress = slaveAddress;
        Monitor.logTextMessage("R011", dbname, slaveAddress.getHostAddress().getHostName(), String.valueOf(slaveAddress.getPortNumber()));
    }

    public void initConnection(int timeout, long synchOnInstant, String dbname) throws PrivilegedActionException, IOException, StandardException, ClassNotFoundException {
        if (this.serverSocket == null) {
            this.serverSocket = this.createServerSocket();
        }
        this.serverSocket.setSoTimeout(timeout);
        Socket client = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                return ReplicationMessageReceive.this.serverSocket.accept();
            }
        });
        this.socketConn = new SocketConnection(client);
        this.parseAndAckVersion(this.readMessage(), dbname);
        this.parseAndAckInstant(this.readMessage(), synchOnInstant, dbname);
        this.killPingThread = false;
        this.pingThread = new SlavePingThread(dbname);
        this.pingThread.setDaemon(true);
        this.pingThread.start();
    }

    private ServerSocket createServerSocket() throws PrivilegedActionException {
        return (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException, StandardException {
                ServerSocketFactory sf = ServerSocketFactory.getDefault();
                return sf.createServerSocket(ReplicationMessageReceive.this.slaveAddress.getPortNumber(), 0, ReplicationMessageReceive.this.slaveAddress.getHostAddress());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void tearDown() throws IOException {
        Object object = this.sendPingSemaphore;
        synchronized (object) {
            this.killPingThread = true;
            this.sendPingSemaphore.notify();
        }
        try {
            if (this.socketConn != null) {
                this.socketConn.tearDown();
            }
            Object var4_3 = null;
            if (this.serverSocket == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.serverSocket == null) throw throwable;
            this.serverSocket.close();
            throw throwable;
        }
        this.serverSocket.close();
    }

    private void parseAndAckVersion(ReplicationMessage initiatorMessage, String dbname) throws IOException, StandardException {
        long masterVersion;
        ReplicationMessage ack = null;
        if (initiatorMessage.getType() != 0) {
            String expectedMsgId = String.valueOf(0);
            String receivedMsgId = String.valueOf(initiatorMessage.getType());
            this.handleUnexpectedMessage(dbname, expectedMsgId, receivedMsgId);
        }
        if ((masterVersion = ((Long)initiatorMessage.getMessage()).longValue()) != 1L) {
            ack = new ReplicationMessage(12, new String[]{"XRE02"});
            this.sendMessage(ack);
            throw StandardException.newException("XRE02");
        }
        ack = new ReplicationMessage(11, "UID OK");
        this.sendMessage(ack);
    }

    private void parseAndAckInstant(ReplicationMessage initiatorMessage, long synchOnInstant, String dbname) throws IOException, StandardException {
        long masterInstant;
        ReplicationMessage ack = null;
        if (initiatorMessage.getType() != 1) {
            String expectedMsgId = String.valueOf(1);
            String receivedMsgId = String.valueOf(initiatorMessage.getType());
            this.handleUnexpectedMessage(dbname, expectedMsgId, receivedMsgId);
        }
        if ((masterInstant = ((Long)initiatorMessage.getMessage()).longValue()) != synchOnInstant) {
            Object[] exception = new String[]{dbname, String.valueOf(LogCounter.getLogFileNumber(masterInstant)), String.valueOf(LogCounter.getLogFilePosition(masterInstant)), String.valueOf(LogCounter.getLogFileNumber(synchOnInstant)), String.valueOf(LogCounter.getLogFilePosition(synchOnInstant)), "XRE05"};
            ack = new ReplicationMessage(12, exception);
            this.sendMessage(ack);
            throw StandardException.newException("XRE05", exception);
        }
        ack = new ReplicationMessage(11, "Instant OK");
        this.sendMessage(ack);
    }

    private void handleUnexpectedMessage(String dbname, String expextedMsgId, String receivedMsgId) throws StandardException, IOException {
        Object[] exception = new String[]{dbname, expextedMsgId, receivedMsgId, "XRE12"};
        ReplicationMessage ack = new ReplicationMessage(12, exception);
        this.sendMessage(ack);
        throw StandardException.newException("XRE12", exception);
    }

    public void sendMessage(ReplicationMessage message) throws IOException {
        this.checkSocketConnection();
        this.socketConn.writeMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationMessage readMessage() throws ClassNotFoundException, IOException {
        this.checkSocketConnection();
        ReplicationMessage msg = (ReplicationMessage)this.socketConn.readMessage();
        if (msg.getType() == 14) {
            Object object = this.receivePongSemaphore;
            synchronized (object) {
                this.connectionConfirmed = true;
                this.receivePongSemaphore.notify();
            }
            return this.readMessage();
        }
        return msg;
    }

    private void checkSocketConnection() throws IOException {
        if (this.socketConn == null) {
            throw new IOException("R012");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isConnectedToMaster() {
        Object object = this.receivePongSemaphore;
        synchronized (object) {
            this.connectionConfirmed = false;
            Object object2 = this.sendPingSemaphore;
            synchronized (object2) {
                this.sendPingSemaphore.notify();
            }
            try {
                this.receivePongSemaphore.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.connectionConfirmed;
    }

    private class SlavePingThread
    extends Thread {
        private final ReplicationMessage pingMsg;

        SlavePingThread(String dbname) {
            super("derby.slave.ping-" + dbname);
            this.pingMsg = new ReplicationMessage(13, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (!ReplicationMessageReceive.this.killPingThread) {
                    Object object = ReplicationMessageReceive.this.sendPingSemaphore;
                    synchronized (object) {
                        ReplicationMessageReceive.this.sendPingSemaphore.wait();
                    }
                    if (!ReplicationMessageReceive.this.killPingThread) {
                        ReplicationMessageReceive.this.sendMessage(this.pingMsg);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ie) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

