/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.Token;
import org.apache.derby.impl.tools.ij.ij;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.impl.tools.ij.ijResult;
import org.apache.derby.impl.tools.ij.ijVectorResult;
import org.apache.derby.impl.tools.ij.ijXid;
import org.apache.derby.impl.tools.ij.xaAbstractHelper;

class xaHelper
implements xaAbstractHelper {
    private XADataSource currentXADataSource;
    private XAConnection currentXAConnection;
    private String databaseName;
    private DataSource currentDataSource;
    private ConnectionPoolDataSource currentCPDataSource;
    private PooledConnection currentPooledConnection;
    private boolean isJCC;
    private boolean isNetClient;
    private String framework;
    private static final Class[] STRING_P = new Class[]{"".getClass()};
    private static final Class[] INT_P = new Class[]{Integer.TYPE};
    private static final Class[] BOOLEAN_P = new Class[]{Boolean.TYPE};

    xaHelper() {
    }

    public void setFramework(String fm) {
        if (fm == null) {
            return;
        }
        this.framework = fm.toUpperCase(Locale.ENGLISH);
        if (this.framework.endsWith("NET") || this.framework.equals("DB2JCC")) {
            this.isJCC = true;
        } else if (this.framework.equals("DERBYNETCLIENT")) {
            this.isNetClient = true;
        }
    }

    private Xid makeXid(int xid) {
        try {
            return new ijXid(xid, this.databaseName.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void XADataSourceStatement(ij parser, Token dbname, Token shutdown, String create) throws SQLException {
        try {
            this.currentXADataSource = this.getXADataSource();
            this.databaseName = parser.stringValue(dbname.image);
            if (this.isJCC || this.isNetClient) {
                String hostName = System.getProperty("hostName");
                if (hostName != null && !hostName.equals("localhost")) {
                    xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "ServerName", hostName);
                } else {
                    xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "ServerName", "localhost");
                }
                xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "portNumber", 1527);
                String user = "APP";
                String password = "APP";
                xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "user", user);
                xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "password", password);
            }
            if (this.isJCC) {
                xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "driverType", 4);
                xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "retrieveMessagesFromServerOnGetMessage", true);
            }
            xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "databaseName", this.databaseName);
            if (shutdown != null && shutdown.toString().toLowerCase(Locale.ENGLISH).equals("shutdown")) {
                if (this.isJCC || this.isNetClient) {
                    xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "databaseName", this.databaseName + ";shutdown=true");
                } else {
                    xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "shutdownDatabase", "shutdown");
                }
                this.currentXADataSource.getXAConnection().getConnection();
                this.currentXADataSource = null;
                this.currentXAConnection = null;
            } else if (create != null && create.toLowerCase(Locale.ENGLISH).equals("create")) {
                if (this.isJCC || this.isNetClient) {
                    xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "databaseName", this.databaseName + ";create=true");
                } else {
                    xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "createDatabase", "create");
                }
                XAConnection conn = this.currentXADataSource.getXAConnection();
                conn.close();
                xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "createDatabase", null);
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    public void XAConnectStatement(ij parser, Token user, Token pass, String id) throws SQLException {
        try {
            if (this.currentXAConnection != null) {
                try {
                    this.currentXAConnection.close();
                }
                catch (SQLException sqle) {
                    // empty catch block
                }
                this.currentXAConnection = null;
            }
            String username = null;
            String password = "";
            if (pass != null) {
                password = parser.stringValue(pass.image);
            }
            if (user != null) {
                username = parser.stringValue(user.image);
                this.currentXAConnection = this.currentXADataSource.getXAConnection(username, password);
            } else {
                this.currentXAConnection = this.currentXADataSource.getXAConnection();
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    public void XADisconnectStatement(ij parser, String n) throws SQLException {
        if (this.currentXAConnection == null) {
            throw ijException.noSuchConnection("XAConnection");
        }
        this.currentXAConnection.close();
        this.currentXAConnection = null;
    }

    public Connection XAGetConnectionStatement(ij parser, String n) throws SQLException {
        try {
            return this.currentXAConnection.getConnection();
        }
        catch (Throwable t) {
            this.handleException(t);
            return null;
        }
    }

    public void CommitStatement(ij parser, Token onePhase, Token twoPhase, int xid) throws SQLException {
        try {
            this.currentXAConnection.getXAResource().commit(this.makeXid(xid), onePhase != null);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    public void EndStatement(ij parser, int flag, int xid) throws SQLException {
        try {
            this.currentXAConnection.getXAResource().end(this.makeXid(xid), flag);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    public void ForgetStatement(ij parser, int xid) throws SQLException {
        try {
            this.currentXAConnection.getXAResource().forget(this.makeXid(xid));
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    public void PrepareStatement(ij parser, int xid) throws SQLException {
        try {
            this.currentXAConnection.getXAResource().prepare(this.makeXid(xid));
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    public ijResult RecoverStatement(ij parser, int flag) throws SQLException {
        Xid[] val = null;
        try {
            val = this.currentXAConnection.getXAResource().recover(flag);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        Vector<String> v = new Vector<String>();
        v.addElement("");
        v.addElement(LocalizedResource.getMessage("IJ_Reco0InDoubT", LocalizedResource.getNumber(val.length)));
        v.addElement("");
        for (int i = 0; i < val.length; ++i) {
            v.addElement(LocalizedResource.getMessage("IJ_Tran01", LocalizedResource.getNumber(i + 1), val[i].toString()));
        }
        return new ijVectorResult(v, null);
    }

    public void RollbackStatement(ij parser, int xid) throws SQLException {
        try {
            this.currentXAConnection.getXAResource().rollback(this.makeXid(xid));
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    public void StartStatement(ij parser, int flag, int xid) throws SQLException {
        try {
            this.currentXAConnection.getXAResource().start(this.makeXid(xid), flag);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    private void handleException(Throwable t) throws SQLException {
        if (t instanceof SQLException) {
            throw (SQLException)t;
        }
        if (t instanceof XAException) {
            int errorCode = ((XAException)t).errorCode;
            String error = LocalizedResource.getMessage("IJ_IlleValu");
            switch (errorCode) {
                case 7: {
                    error = "XA_HEURCOM ";
                    break;
                }
                case 8: {
                    error = "XA_HEURHAZ";
                    break;
                }
                case 5: {
                    error = "XA_HEURMIX";
                    break;
                }
                case 6: {
                    error = "XA_HEURRB ";
                    break;
                }
                case 9: {
                    error = "XA_NOMIGRATE ";
                    break;
                }
                case 101: {
                    error = "XA_RBCOMMFAIL ";
                    break;
                }
                case 102: {
                    error = "XA_RBDEADLOCK ";
                    break;
                }
                case 103: {
                    error = "XA_RBINTEGRITY ";
                    break;
                }
                case 104: {
                    error = "XA_RBOTHER ";
                    break;
                }
                case 105: {
                    error = "XA_RBPROTO ";
                    break;
                }
                case 100: {
                    error = "XA_RBROLLBACK ";
                    break;
                }
                case 106: {
                    error = "XA_RBTIMEOUT ";
                    break;
                }
                case 107: {
                    error = "XA_RBTRANSIENT ";
                    break;
                }
                case 3: {
                    error = "XA_RDONLY ";
                    break;
                }
                case 4: {
                    error = "XA_RETRY ";
                    break;
                }
                case -2: {
                    error = "XAER_ASYNC ";
                    break;
                }
                case -8: {
                    error = "XAER_DUPID ";
                    break;
                }
                case -5: {
                    error = "XAER_INVAL ";
                    break;
                }
                case -4: {
                    error = "XAER_NOTA ";
                    break;
                }
                case -9: {
                    error = "XAER_OUTSIDE ";
                    break;
                }
                case -6: {
                    error = "XAER_PROTO ";
                    break;
                }
                case -3: {
                    error = "XAER_RMERR ";
                    break;
                }
                case -7: {
                    error = "XAER_RMFAIL ";
                }
            }
            throw new ijException(error);
        }
        String info = LocalizedResource.getMessage("IJ_01SeeLog", t.toString(), t.getMessage());
        throw new ijException(info);
    }

    public Connection DataSourceStatement(ij parser, Token dbname, Token protocol, Token userT, Token passT, String id) throws SQLException {
        try {
            this.currentDataSource = (DataSource)Class.forName("org.apache.derby.jdbc.EmbeddedDataSource").newInstance();
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
        this.databaseName = parser.stringValue(dbname.image);
        xaHelper.setDataSourceProperty((Object)this.currentDataSource, "databaseName", this.databaseName);
        xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "dataSourceName", this.databaseName);
        Connection c = null;
        String username = null;
        String password = "";
        if (passT != null) {
            password = parser.stringValue(passT.image);
        }
        if (userT != null) {
            username = parser.stringValue(userT.image);
            c = this.currentDataSource.getConnection(username, password);
        } else {
            c = this.currentDataSource.getConnection();
        }
        return c;
    }

    public void CPDataSourceStatement(ij parser, Token dbname, Token protocol) throws SQLException {
        try {
            this.currentCPDataSource = (ConnectionPoolDataSource)Class.forName("org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource").newInstance();
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
        this.databaseName = parser.stringValue(dbname.image);
        xaHelper.setDataSourceProperty((Object)this.currentCPDataSource, "databaseName", this.databaseName);
    }

    public void CPConnectStatement(ij parser, Token userT, Token passT, String n) throws SQLException {
        String username = null;
        String password = "";
        if (passT != null) {
            password = parser.stringValue(passT.image);
        }
        if (userT != null) {
            username = parser.stringValue(userT.image);
            this.currentPooledConnection = this.currentCPDataSource.getPooledConnection(username, password);
        } else {
            this.currentPooledConnection = this.currentCPDataSource.getPooledConnection();
        }
    }

    public Connection CPGetConnectionStatement(ij parser, String n) throws SQLException {
        return this.currentPooledConnection.getConnection();
    }

    public void CPDisconnectStatement(ij parser, String n) throws SQLException {
        if (this.currentPooledConnection == null) {
            throw ijException.noSuchConnection(LocalizedResource.getMessage("IJ_Pool"));
        }
        this.currentPooledConnection.close();
        this.currentPooledConnection = null;
    }

    private XADataSource getXADataSource() throws Exception {
        try {
            if (this.isJCC) {
                return (XADataSource)Class.forName("com.ibm.db2.jcc.DB2XADataSource").newInstance();
            }
            if (this.isNetClient) {
                if (JVMInfo.JDK_ID >= 7) {
                    try {
                        return (XADataSource)Class.forName("org.apache.derby.jdbc.ClientXADataSource40").newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                return (XADataSource)Class.forName("org.apache.derby.jdbc.ClientXADataSource").newInstance();
            }
            if (JVMInfo.JDK_ID >= 7) {
                try {
                    return (XADataSource)Class.forName("org.apache.derby.jdbc.EmbeddedXADataSource40").newInstance();
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            return (XADataSource)Class.forName("org.apache.derby.jdbc.EmbeddedXADataSource").newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new ijException(LocalizedResource.getMessage("IJ_XAClass"));
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        throw new ijException(LocalizedResource.getMessage("IJ_XANoI"));
    }

    private static void setDataSourceProperty(Object ds, String property, int value) throws SQLException {
        String methodName = "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
        try {
            Method m = ds.getClass().getMethod(methodName, INT_P);
            m.invoke(ds, new Integer(value));
        }
        catch (Exception e) {
            throw new SQLException(property + " ???" + e.getMessage());
        }
    }

    private static void setDataSourceProperty(Object ds, String property, String value) throws SQLException {
        String methodName = "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
        try {
            Method m = ds.getClass().getMethod(methodName, STRING_P);
            m.invoke(ds, value);
            return;
        }
        catch (Exception nsme) {
            throw new SQLException(property + " ???");
        }
    }

    private static void setDataSourceProperty(Object ds, String property, boolean value) throws SQLException {
        String methodName = "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
        try {
            Method m = ds.getClass().getMethod(methodName, BOOLEAN_P);
            m.invoke(ds, new Boolean(value));
            return;
        }
        catch (Exception nsme) {
            throw new SQLException(property + " ???");
        }
    }
}

