/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2;

import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.ode.axis2.ODEServer;
import org.apache.ode.axis2.ODEService;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessStore;

public class BindingContextImpl
implements BindingContext {
    private ODEServer _server;
    private ProcessStore _store;

    public BindingContextImpl(ODEServer oDEServer, ProcessStore processStore) {
        this._server = oDEServer;
        this._store = processStore;
    }

    public EndpointReference activateMyRoleEndpoint(QName qName, Endpoint endpoint) {
        try {
            ProcessConf processConf = this._store.getProcessConfiguration(qName);
            Definition definition = processConf.getDefinitionForService(endpoint.serviceName);
            if (definition == null) {
                throw new ContextException("Unable to access WSDL definition to activate MyRole endpoint for service " + endpoint.serviceName + " and port " + endpoint.portName);
            }
            ODEService oDEService = this._server.createService(processConf, endpoint.serviceName, endpoint.portName);
            return oDEService.getMyServiceRef();
        }
        catch (AxisFault axisFault) {
            throw new ContextException("Could not activate endpoint for service " + endpoint.serviceName + " and port " + endpoint.portName, (Throwable)axisFault);
        }
    }

    public void deactivateMyRoleEndpoint(Endpoint endpoint) {
        this._server.destroyService(endpoint.serviceName, endpoint.portName);
    }

    public PartnerRoleChannel createPartnerRoleChannel(QName qName, PortType portType, Endpoint endpoint) {
        ProcessConf processConf = this._store.getProcessConfiguration(qName);
        Definition definition = processConf.getDefinitionForService(endpoint.serviceName);
        if (definition == null) {
            throw new ContextException("Cannot find definition for service " + endpoint.serviceName + " in the context of process " + qName);
        }
        return this._server.createExternalService(processConf, endpoint.serviceName, endpoint.portName);
    }
}

