/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.httpbinding;

import java.io.IOException;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.httpbinding.ProxyConf;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.http.HttpUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HttpHelper {
    private static final Log log = LogFactory.getLog(HttpHelper.class);
    private static final Pattern NON_LWS_PATTERN = Pattern.compile("\r\n([^\\s])");

    public static void configure(HttpClient httpClient, URI uRI, Element element, HttpParams httpParams) throws URIException {
        Element element2;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuring http client...");
        }
        httpClient.getParams().setDefaults(httpParams);
        httpClient.getParams().setParameter("http.default-headers", (Object)Collections.EMPTY_LIST);
        if (ProxyConf.isProxyEnabled(httpParams, uRI.getHost())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ProxyConf");
            }
            ProxyConf.configure(httpClient.getHostConfiguration(), httpClient.getState(), (HttpTransportProperties.ProxyProperties)httpParams.getParameter("http.proxy."));
        }
        if (element != null && (element2 = DOMUtils.getFirstChildElement((Element)element)) != null && element2.getAttributes().getLength() != 0) {
            String string = DOMUtils.getAttribute((Element)element2, (String)"scheme");
            String string2 = DOMUtils.getAttribute((Element)element2, (String)"username");
            String string3 = DOMUtils.getAttribute((Element)element2, (String)"password");
            if (!(string == null || "server-decides".equalsIgnoreCase(string) || "basic".equalsIgnoreCase(string) || "digest".equalsIgnoreCase(string))) {
                throw new IllegalArgumentException("Unknown Authentication scheme: [" + string + "] Accepted values are: Basic, Digest, Server-Decides");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"credentials provided");
            }
            httpClient.getState().setCredentials(new AuthScope(uRI.getHost(), uRI.getPort(), AuthScope.ANY_REALM, string), (Credentials)new UsernamePasswordCredentials(string2, string3));
            httpClient.getParams().setAuthenticationPreemptive("basic".equalsIgnoreCase(string));
        }
    }

    public static Element statusLineToElement(String string) throws HttpException {
        return HttpHelper.statusLineToElement(new StatusLine(string));
    }

    public static Element statusLineToElement(StatusLine statusLine) {
        return HttpHelper.statusLineToElement(DOMUtils.newDocument(), statusLine);
    }

    public static Element statusLineToElement(Document document, StatusLine statusLine) {
        Element element = document.createElementNS(null, "Status-Line");
        Element element2 = document.createElementNS(null, "HTTP-Version");
        Element element3 = document.createElementNS(null, "Status-Code");
        Element element4 = document.createElementNS(null, "Reason-Phrase");
        Element element5 = document.createElementNS(null, "original");
        document.appendChild(element);
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        element.appendChild(element5);
        element2.setTextContent(statusLine.getHttpVersion());
        element3.setTextContent(String.valueOf(statusLine.getStatusCode()));
        element4.setTextContent(statusLine.getReasonPhrase());
        element5.setTextContent(statusLine.toString());
        return element;
    }

    public static Element prepareDetailsElement(HttpMethod httpMethod) {
        Element element;
        block7: {
            Header header = httpMethod.getResponseHeader("Content-Type");
            String string = header != null ? header.getValue() : null;
            boolean bl = string != null && HttpUtils.isXml((String)string);
            Document document = DOMUtils.newDocument();
            element = document.createElementNS(null, "details");
            Element element2 = HttpHelper.statusLineToElement(document, httpMethod.getStatusLine());
            element.appendChild(element2);
            try {
                String string2 = httpMethod.getResponseBodyAsString();
                if (!StringUtils.isNotEmpty((String)string2)) break block7;
                Element element3 = document.createElementNS(null, "responseBody");
                element.appendChild(element3);
                boolean bl2 = false;
                if (bl) {
                    try {
                        Element element4 = DOMUtils.stringToDOM((String)string2);
                        element3.appendChild(document.importNode(element4, true));
                    }
                    catch (Exception exception) {
                        String string3 = "Unable to parse the response body as xml. Body will be inserted as string.";
                        if (log.isDebugEnabled()) {
                            log.debug((Object)string3, (Throwable)exception);
                        }
                        bl2 = true;
                    }
                }
                if (!bl || bl2) {
                    element3.setTextContent(string2);
                }
            }
            catch (IOException iOException) {
                if (!log.isWarnEnabled()) break block7;
                log.warn((Object)"Exception while loading response body", (Throwable)iOException);
            }
        }
        return element;
    }

    public static String replaceCRLFwithLWS(String string) {
        Matcher matcher = NON_LWS_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "\r\n\t");
            stringBuffer.append(matcher.group(1));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String requestToString(HttpMethod httpMethod) {
        EntityEnclosingMethod entityEnclosingMethod;
        Header header;
        StringBuilder stringBuilder;
        block6: {
            stringBuilder = new StringBuilder(256);
            try {
                stringBuilder.append("HTTP Request Details: \n").append(httpMethod.getName()).append(" ").append(httpMethod.getURI());
            }
            catch (URIException uRIException) {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)uRIException);
            }
        }
        stringBuilder.append("\nRequest Headers:");
        Header[] headerArray = httpMethod.getRequestHeaders();
        if (headerArray.length == 0) {
            stringBuilder.append(" n/a");
        }
        for (int i = 0; i < headerArray.length; ++i) {
            header = headerArray[i];
            stringBuilder.append("\n\t").append(header.getName()).append(": ").append(header.getValue());
        }
        if (httpMethod instanceof EntityEnclosingMethod && (entityEnclosingMethod = (EntityEnclosingMethod)httpMethod).getRequestEntity() != null) {
            stringBuilder.append("\nRequest Entity:");
            stringBuilder.append("\n\tContent-Type:").append(entityEnclosingMethod.getRequestEntity().getContentType());
            stringBuilder.append("\n\tContent-Length:").append(entityEnclosingMethod.getRequestEntity().getContentLength());
            if (entityEnclosingMethod.getRequestEntity() instanceof StringRequestEntity) {
                header = (StringRequestEntity)entityEnclosingMethod.getRequestEntity();
                stringBuilder.append("\n\tContent-Charset:").append(header.getCharset());
                stringBuilder.append("\n\tRequest Entity:\n").append(header.getContent());
            }
        }
        return stringBuilder.toString();
    }

    public static String responseToString(HttpMethod httpMethod) {
        StringBuilder stringBuilder;
        block9: {
            stringBuilder = new StringBuilder(256);
            try {
                stringBuilder.append("HTTP Response Details: \n").append(httpMethod.getName()).append(" ").append(httpMethod.getURI());
            }
            catch (URIException uRIException) {
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)uRIException);
            }
        }
        stringBuilder.append("\nStatus-Line: ").append(httpMethod.getStatusLine());
        Header[] headerArray = httpMethod.getResponseHeaders();
        if (headerArray.length != 0) {
            stringBuilder.append("\nResponse Headers: ");
        }
        for (int i = 0; i < headerArray.length; ++i) {
            Header header = headerArray[i];
            stringBuilder.append("\n\t").append(header.getName()).append(": ").append(header.getValue());
        }
        try {
            if (StringUtils.isNotEmpty((String)httpMethod.getResponseBodyAsString())) {
                stringBuilder.append("\nResponse Entity:\n").append(httpMethod.getResponseBodyAsString());
            }
        }
        catch (IOException iOException) {
            log.error((Object)iOException);
        }
        Header[] headerArray2 = httpMethod.getResponseFooters();
        if (headerArray2.length != 0) {
            stringBuilder.append("\nResponse Footers: ");
        }
        for (int i = 0; i < headerArray2.length; ++i) {
            Header header = headerArray2[i];
            stringBuilder.append("\n\t").append(header.getName()).append(": ").append(header.getValue());
        }
        return stringBuilder.toString();
    }

    public static int isFaultOrFailure(int n) {
        if (n < 400 || n >= 600) {
            throw new IllegalArgumentException("Status-Code must be in interval [400;600[");
        }
        if (n == 500 || n == 501 || n == 502 || n == 505 || n == 400 || n == 402 || n == 403 || n == 404 || n == 405 || n == 406 || n == 407 || n == 409 || n == 410 || n == 412 || n == 413 || n == 414 || n == 415 || n == 411 || n == 416 || n == 417) {
            return 1;
        }
        if (n == 503 || n == 504 || n == 401 || n == 408) {
            return -1;
        }
        return 0;
    }
}

