/**********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.bulkbuilder.test;

import junit.framework.TestCase;

import org.eclipse.smila.bulkbuilder.internal.BulkbuilderConfig;

/**
 * Test for {@link BulkbuilderConfig} class.
 */
public class TestBulkbuilderConfig extends TestCase {
  /** factor for Kibibyte values. */
  private static final long KIBI = 1 << 10;

  /** factor for Mebibyte values. */
  private static final long MEBI = 1 << 20;

  /** factor for milliseconds. */
  private static final long MILLI = 1000;

  /** check default values. */
  public void testDefaults() {
    final BulkbuilderConfig defaultConfig = new BulkbuilderConfig();
    assertEquals(10 * MEBI, defaultConfig.getLimitSize());
    assertEquals(120, defaultConfig.getLimitTime());
    assertEquals(120 * MILLI, defaultConfig.getLimitTimeMillis());
    assertEquals(-1, defaultConfig.getMaxParallelMicroBulks());
  }

  /** check config values. */
  public void testBundleConfig() throws Exception {
    final BulkbuilderConfig bundleConfig = new BulkbuilderConfig();
    bundleConfig.readConfiguration();
    assertEquals(10 * KIBI, bundleConfig.getLimitSize());
    assertEquals(2, bundleConfig.getLimitTime());
    assertEquals(2 * MILLI, bundleConfig.getLimitTimeMillis());
    assertEquals(2, bundleConfig.getMaxParallelMicroBulks());
  }
}
