/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.bulkbuilder;

import org.eclipse.smila.utils.http.NotFoundHTTPResult;

/**
 * thrown on request to undefined jobs.
 * 
 */
public class InvalidJobException extends BulkbuilderException implements NotFoundHTTPResult {
  /** is serializable, so ... */
  private static final long serialVersionUID = 1L;

  /**
   * create exception with details message.
   * 
   * @param message
   *          details message
   * @param cause
   *          causing exception
   */
  public InvalidJobException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /**
   * create exception with details message and cause.
   * 
   * @param message
   *          details message
   */
  public InvalidJobException(final String message) {
    super(message);
  }

}
