/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.clusterconfig.simple.test;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Suite combining the simple cluster configuration bundle tests.
 * 
 */
public final class AllTests {
  public static final String BUNDLE_ID = "org.eclipse.smila.clusterconfig.simple.test";

  /**
   * utility class, do not create instances.
   */
  private AllTests() {
    ; // nothing
  }

  /**
   * @return suite for all org.eclipse.smila.clusterconfig.simple tests
   */
  public static Test suite() {
    final TestSuite suite = new TestSuite(BUNDLE_ID);
    // $JUnit-BEGIN$
    suite.addTestSuite(TestSimpleClusterConfig.class);
    suite.addTestSuite(TestSimpleClusterConfigDefaultValues.class);
    // $JUnit-END$
    return suite;
  }
}
