/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Daniel Stucky (empolis GmbH) - initial API and implementation
 **********************************************************************************************************************/
package org.eclipse.smila.connectivity.bulkbuilder.test;

import org.eclipse.smila.connectivity.ConnectivityException;
import org.eclipse.smila.connectivity.ConnectivityId;
import org.eclipse.smila.connectivity.ConnectivityManager;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.jobmanager.JobRunEngine;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.JobDefinition;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

/**
 * The Class TestConnectivity.
 */
public class TestConnectivity extends DeclarativeServiceTestCase {

  /**
   * the ConnectivityManager.
   */
  private ConnectivityManager _connectivityManager;

  /**
   * {@inheritDoc}
   * 
   * @see junit.framework.TestCase#setUp()
   */
  @Override
  protected void setUp() throws Exception {
    _connectivityManager = getService(ConnectivityManager.class);
  }

  /**
   * {@inheritDoc}
   * 
   * @see junit.framework.TestCase#tearDown()
   */
  @Override
  protected void tearDown() throws Exception {
    if (_connectivityManager != null) {
      _connectivityManager = null;
    }
  }

  /**
   * Test {@link ConnectivityManager#add(Record[])}.
   * 
   * @throws Exception
   *           the Exception
   */
  public void testAdd() throws Exception {
    final String jobName = "dummyJobAdd";
    final String jobRunId = startJob(jobName);
    final String dataSourceId = "testDataSource";
    final Record[] records = TestUtil.createDiRecord(dataSourceId);
    final int addCount = _connectivityManager.add(records, jobName);
    assertEquals(records.length, addCount);
    finishJob(jobName, jobRunId);
  }

  /**
   * Test {@link ConnectivityManager#delete(Id[])}.
   * 
   * @throws Exception
   *           the Exception
   */
  public void testDelete() throws Exception {
    final String jobName = "dummyJobDelete";
    final String jobRunId = startJob(jobName);
    final String dataSourceId = "testDataSource";
    final ConnectivityId[] ids = TestUtil.createIds(dataSourceId);
    final Record[] records = new Record[ids.length];
    for (int i = 0; i < ids.length; i++) {
      records[i] = DataFactory.DEFAULT.createRecord();
      records[i].setId(ids[i].getObjectId());
      records[i].setSource(ids[i].getDataSourceId());
    } // for
    final int deleteCount = _connectivityManager.delete(records, jobName);
    assertEquals(ids.length, deleteCount);
    finishJob(jobName, jobRunId);
  }

  /** test the {@link ConnectivityManager#checkJobIsActive(String)} method. */
  public void testCheckJobIsActive() throws Exception {
    final String jobName = "dummyJobCheck";
    try {
      _connectivityManager.checkJobIsActive(jobName);
      fail("should not work");
    } catch (final ConnectivityException ex) {
      System.out.println(ex);
    }
    final String jobRunId = startJob(jobName);
    _connectivityManager.checkJobIsActive(jobName);
    finishJob(jobName, jobRunId);
    try {
      _connectivityManager.checkJobIsActive(jobName);
      fail("should not work");
    } catch (final ConnectivityException ex) {
      System.out.println(ex);
    }
  }

  /** helper method for creating and starting a job. */
  private String startJob(final String jobName) throws Exception {
    final JobRunEngine jobmanager = getService(JobRunEngine.class);
    final DefinitionPersistence defPersistence = getService(DefinitionPersistence.class);
    final AnyMap jobDef = DataFactory.DEFAULT.createAnyMap();
    jobDef.put(JobDefinition.KEY_WORKFLOW, "testWorkflow");
    jobDef.put(JobDefinition.KEY_NAME, jobName);
    defPersistence.addJob(new JobDefinition(jobDef));
    return jobmanager.startJob(jobName);
  }

  /** helper method for finishing a job run. */
  private void finishJob(final String jobName, final String jobRunId) throws Exception {
    final JobRunEngine jobmanager = getService(JobRunEngine.class);
    jobmanager.finishJob(jobName, jobRunId);
  }
}
