/***********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.connectivity.framework.crawler.test;

import java.util.concurrent.atomic.AtomicInteger;

import org.eclipse.smila.connectivity.ConnectivityId;
import org.eclipse.smila.connectivity.framework.AbstractCrawler;
import org.eclipse.smila.connectivity.framework.CrawlerCriticalException;
import org.eclipse.smila.connectivity.framework.CrawlerException;
import org.eclipse.smila.connectivity.framework.DataReference;
import org.eclipse.smila.connectivity.framework.performancecounters.ConnectivityPerformanceAgent;
import org.eclipse.smila.connectivity.framework.performancecounters.CrawlerPerformanceCounterHelper;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.util.DataReferenceFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;

/**
 * Crawler for testing purposes. Does nothing. Just waits to be finished.
 */
public class TestWaitCrawler extends AbstractCrawler {

  /** the performance counter. */
  private CrawlerPerformanceCounterHelper<ConnectivityPerformanceAgent> _performanceCounters;

  /** id generator. */
  private final AtomicInteger _id = new AtomicInteger(0);

  /** data source id. */
  private String _dataSourceId;

  /** {@inheritDoc} */
  @Override
  public DataReference[] getNext() throws CrawlerException, CrawlerCriticalException {
    try {
      Thread.sleep(100);
      _performanceCounters.incrementRecords();
    } catch (final InterruptedException e) {
      throw new CrawlerCriticalException("Interrupted", e);
    }
    final ConnectivityId cid = new ConnectivityId(_dataSourceId, String.valueOf(_id.getAndIncrement()));
    return new DataReference[] { DataReferenceFactory.getInstance().createDataReference(this, cid, cid.getIdHash()) };
  }

  /** {@inheritDoc} */
  @Override
  public void initialize(final DataSourceConnectionConfig config) throws CrawlerException, CrawlerCriticalException {
    _performanceCounters =
      new CrawlerPerformanceCounterHelper<ConnectivityPerformanceAgent>(config, hashCode(),
        ConnectivityPerformanceAgent.class);
    _dataSourceId = config.getDataSourceID();
  }

  /** {@inheritDoc} */
  @Override
  public void close() throws CrawlerException {
  }

  /** {@inheritDoc} */
  @Override
  public CrawlerPerformanceCounterHelper<? extends ConnectivityPerformanceAgent> getCounterHelper() {
    return _performanceCounters;
  }

  /** {@inheritDoc} */
  @Override
  public AnyMap getMetadata(final ConnectivityId id) throws CrawlerException, CrawlerCriticalException {
    return DataFactory.DEFAULT.createAnyMap();
  }

  /** {@inheritDoc} */
  @Override
  public String[] getAttachmentNames(final ConnectivityId id) throws CrawlerException, CrawlerCriticalException {
    return new String[0];
  }

  /** {@inheritDoc} */
  @Override
  public byte[] getAttachment(final ConnectivityId id, final String name) throws CrawlerException,
    CrawlerCriticalException {
    return new byte[0];
  }

  /** {@inheritDoc} */
  @Override
  public void dispose(final ConnectivityId id) {
  }
}
