/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.connectivity.framework.test;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.JobRunEngine;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.JobDefinition;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

/** base class for connectivity tests that need to create jobs to work. */
public abstract class ConnectivityTestBase extends DeclarativeServiceTestCase {

  /** helper method for creating and starting a job. */
  protected String startJob(final String jobName) throws Exception {
    final JobRunEngine jobmanager = getService(JobRunEngine.class);
    final DefinitionPersistence defPersistence = getService(DefinitionPersistence.class);
    final AnyMap jobDef = DataFactory.DEFAULT.createAnyMap();
    jobDef.put(JobDefinition.KEY_WORKFLOW, "testWorkflow");
    jobDef.put(JobDefinition.KEY_NAME, jobName);
    defPersistence.addJob(new JobDefinition(jobDef));
    return jobmanager.startJob(jobName);
  }

  /** helper method for finishing a job run. */
  protected void finishJob(final String jobName, final String jobRunId) throws Exception {
    final JobRunEngine jobmanager = getService(JobRunEngine.class);
    jobmanager.finishJob(jobName, jobRunId);
  }

}
