/***********************************************************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Daniel Stucky (empolis GmbH) - initial API and implementation Sebastian Voigt (Brox IT-Solutions GmbH)
 **********************************************************************************************************************/
package org.eclipse.smila.connectivity.framework.test;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.eclipse.smila.connectivity.framework.AgentControllerAgent;
import org.eclipse.smila.connectivity.framework.util.AgentThreadState;

/**
 * The Class AgentControllerAgent.
 */
public class TestAgentControllerAgent extends ConnectivityTestBase {

  /**
   * Constant for thread sleep time.
   */
  private static final int SLEEP_TIME = 3000;

  /**
   * {@inheritDoc}
   * 
   * @see junit.framework.TestCase#setUp()
   */
  @Override
  protected void setUp() throws Exception {
  }

  /**
   * {@inheritDoc}
   * 
   * @see junit.framework.TestCase#tearDown()
   */
  @Override
  protected void tearDown() throws Exception {
  }

  /**
   * Test {@link AgentControllerAgent#getActiveAgentTaskStatus()}.
   * 
   * @throws Exception
   *           a Exception
   */
  public void testGetActiveAgentStatus() throws Exception {
    final AgentControllerAgent aca = getService(AgentControllerAgent.class);
    assertNotNull(aca);
    final String dataSourceId = "mockAgent";

    final String jobName = getClass().getSimpleName() + "-testGetActiveAgentStatus";
    final String jobRunId = startJob(jobName);
    try {
      aca.startAgentTask(dataSourceId, jobName);
      Map<String, String> agentTasksState = aca.getAgentTasksState();
      assertNotNull(agentTasksState);
      assertEquals(1, agentTasksState.size());
      assertEquals(AgentThreadState.Running.name(), agentTasksState.get(dataSourceId));

      aca.stopAgentTask(dataSourceId);
      agentTasksState = aca.getAgentTasksState();
      assertNotNull(agentTasksState);
      assertEquals(1, agentTasksState.size());
      assertEquals(AgentThreadState.Stopped.name(), agentTasksState.get(dataSourceId));
    } finally {
      finishJob(jobName, jobRunId);
    }
  }

  /**
   * Test {@link AgentControllerAgent#getAvailableAgentTasks()}.
   * 
   * @throws Exception
   *           a Exception
   */
  public void testGetAvailableConfigurations() throws Exception {
    final AgentControllerAgent aca = getService(AgentControllerAgent.class);
    assertNotNull(aca);

    final String[] configs = aca.getAvailableAgentTasks();
    assertNotNull(configs);
    assertEquals(1, configs.length);
  }

  /**
   * Test a Agent run.
   * 
   * @throws Exception
   *           the Exception
   */
  public void testStartAgent() throws Exception {
    final AgentControllerAgent aca = getService(AgentControllerAgent.class);
    assertNotNull(aca);

    final String jobName = getClass().getSimpleName() + "-TestAgentController-testStartAgent";

    final String jobRunId = startJob(jobName);
    try {
      aca.startAgentTask(TestAgentController.AGENT_DATASOURCEID, jobName);

      Map<String, String> agentTasksState = aca.getAgentTasksState();
      assertNotNull(agentTasksState);
      assertEquals(1, agentTasksState.size());
      String agentState = agentTasksState.get(TestAgentController.AGENT_DATASOURCEID);
      assertNotNull(agentState);
      assertEquals(AgentThreadState.Running.toString(), agentState);

      // stop agent
      aca.stopAgentTask(TestAgentController.AGENT_DATASOURCEID);
      Thread.sleep(SLEEP_TIME);

      agentTasksState = aca.getAgentTasksState();
      assertNotNull(agentTasksState);
      assertEquals(1, agentTasksState.size());
      agentState = agentTasksState.get(TestAgentController.AGENT_DATASOURCEID);
      assertNotNull(agentState);
      assertEquals(AgentThreadState.Stopped.toString(), agentState);
    } finally {
      finishJob(jobName, jobRunId);
    }
  }

  /**
   * test the Function get the known Agents.
   * 
   * @throws Exception
   *           in case of weird problems
   */
  public void testAvailableAgents() throws Exception {
    final AgentControllerAgent aca = getService(AgentControllerAgent.class);
    final String[] availAgents = aca.getAvailableAgents();
    assert availAgents.length == 1;
    final List<String> a = Arrays.asList(availAgents);
    assert a.indexOf("MockAgent") > 0;
  }

}
