/***********************************************************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Daniel Stucky (empolis GmbH) - initial API and implementation
 **********************************************************************************************************************/
package org.eclipse.smila.connectivity.framework.test;

import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingManager;
import org.eclipse.smila.connectivity.framework.AgentController;
import org.eclipse.smila.connectivity.framework.CrawlerController;
import org.eclipse.smila.connectivity.framework.impl.AbstractController;
import org.eclipse.smila.connectivity.framework.schema.config.DeltaIndexingType;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

/**
 * The Class TestCrawlerController.
 */
public class TestControllerCallback extends DeclarativeServiceTestCase {

  /**
   * {@inheritDoc}
   * 
   * @see junit.framework.TestCase#setUp()
   */
  @Override
  protected void setUp() throws Exception {
  }

  /**
   * {@inheritDoc}
   * 
   * @see junit.framework.TestCase#tearDown()
   */
  @Override
  protected void tearDown() throws Exception {
  }

  /**
   * Test the CrawlerControllerCallback interface.
   * 
   * @throws Exception
   *           if any error occurs
   */
  public void testCrawlerControllerCallback() throws Exception {
    final CrawlerController crawlerController = getService(CrawlerController.class);
    assertNotNull(crawlerController);
    testDoDeltaIndexing((AbstractController) crawlerController);
    testDoDeltaDelete((AbstractController) crawlerController);
    testDoCheckForUpdate((AbstractController) crawlerController);
  }

  /**
   * Test the AgentControllerCallback interface.
   * 
   * @throws Exception
   *           if any error occurs
   */
  public void testAgentControllerCallback() throws Exception {
    final AgentController agentController = getService(AgentController.class);
    assertNotNull(agentController);
    testDoDeltaIndexing((AbstractController) agentController);
    testDoDeltaDelete((AbstractController) agentController);
    testDoCheckForUpdate((AbstractController) agentController);
  }

  /**
   * Test DoDeltaIndexing.
   * 
   * @param contoller
   *          a AbstractController
   * @throws Exception
   *           if any error occurs
   */
  private void testDoDeltaIndexing(final AbstractController contoller) throws Exception {

    assertTrue(contoller.doDeltaIndexing(DeltaIndexingType.FULL));
    assertTrue(contoller.doDeltaIndexing(DeltaIndexingType.ADDITIVE));
    assertTrue(contoller.doDeltaIndexing(DeltaIndexingType.INITIAL));
    assertFalse(contoller.doDeltaIndexing(DeltaIndexingType.DISABLED));

    // unset delta indexing manager
    final DeltaIndexingManager diManager = contoller.getDeltaIndexingManager();
    contoller.unsetDeltaIndexingManager(diManager);
    try {
      try {
        contoller.doDeltaIndexing(DeltaIndexingType.FULL);
        fail("expected RuntimeException");
      } catch (final RuntimeException e) {
        assertEquals("No DeltaIndexingManager is bound. Only valid DeltaIndexingType is "
          + DeltaIndexingType.DISABLED, e.getMessage());
      }
      try {
        contoller.doDeltaIndexing(DeltaIndexingType.ADDITIVE);
        fail("expected RuntimeException");
      } catch (final RuntimeException e) {
        assertEquals("No DeltaIndexingManager is bound. Only valid DeltaIndexingType is "
          + DeltaIndexingType.DISABLED, e.getMessage());
      }
      try {
        contoller.doDeltaIndexing(DeltaIndexingType.INITIAL);
        fail("expected RuntimeException");
      } catch (final RuntimeException e) {
        assertEquals("No DeltaIndexingManager is bound. Only valid DeltaIndexingType is "
          + DeltaIndexingType.DISABLED, e.getMessage());
      }
      assertFalse(contoller.doDeltaIndexing(DeltaIndexingType.DISABLED));
    } finally {
      // reset delta indexing manager
      contoller.setDeltaIndexingManager(diManager);
    }
  }

  /**
   * Test doDeltaDelete.
   * 
   * @param contoller
   *          a AbstractController
   * @throws Exception
   *           if any error occurs
   */
  private void testDoDeltaDelete(final AbstractController contoller) throws Exception {
    assertTrue(contoller.doDeltaDelete(DeltaIndexingType.FULL));
    assertFalse(contoller.doDeltaDelete(DeltaIndexingType.ADDITIVE));
    assertFalse(contoller.doDeltaDelete(DeltaIndexingType.INITIAL));
    assertFalse(contoller.doDeltaDelete(DeltaIndexingType.DISABLED));

    // unset delta indexing manager
    final DeltaIndexingManager diManager = contoller.getDeltaIndexingManager();
    contoller.unsetDeltaIndexingManager(diManager);
    try {
      try {
        contoller.doDeltaDelete(DeltaIndexingType.FULL);
        fail("expected RuntimeException");
      } catch (final RuntimeException e) {
        assertEquals("No DeltaIndexingManager is bound. Only valid DeltaIndexingType is "
          + DeltaIndexingType.DISABLED, e.getMessage());
      }
      try {
        contoller.doDeltaDelete(DeltaIndexingType.ADDITIVE);
        fail("expected RuntimeException");
      } catch (final RuntimeException e) {
        assertEquals("No DeltaIndexingManager is bound. Only valid DeltaIndexingType is "
          + DeltaIndexingType.DISABLED, e.getMessage());
      }
      try {
        contoller.doDeltaDelete(DeltaIndexingType.INITIAL);
        fail("expected RuntimeException");
      } catch (final RuntimeException e) {
        assertEquals("No DeltaIndexingManager is bound. Only valid DeltaIndexingType is "
          + DeltaIndexingType.DISABLED, e.getMessage());
      }
      assertFalse(contoller.doDeltaDelete(DeltaIndexingType.DISABLED));
    } finally {
      // reset delta indexing manager
      contoller.setDeltaIndexingManager(diManager);
    }
  }

  /**
   * Test doCheckForUpdate.
   * 
   * @param contoller
   *          a AbstractController
   * @throws Exception
   *           if any error occurs
   */
  private void testDoCheckForUpdate(final AbstractController contoller) throws Exception {
    assertTrue(contoller.doCheckForUpdate(DeltaIndexingType.FULL));
    assertTrue(contoller.doCheckForUpdate(DeltaIndexingType.ADDITIVE));
    assertFalse(contoller.doCheckForUpdate(DeltaIndexingType.INITIAL));
    assertFalse(contoller.doCheckForUpdate(DeltaIndexingType.DISABLED));

    // unset delta indexing manager
    final DeltaIndexingManager diManager = contoller.getDeltaIndexingManager();
    contoller.unsetDeltaIndexingManager(diManager);
    try {
      try {
        contoller.doCheckForUpdate(DeltaIndexingType.FULL);
        fail("expected RuntimeException");
      } catch (final RuntimeException e) {
        assertEquals("No DeltaIndexingManager is bound. Only valid DeltaIndexingType is "
          + DeltaIndexingType.DISABLED, e.getMessage());
      }
      try {
        contoller.doCheckForUpdate(DeltaIndexingType.ADDITIVE);
        fail("expected RuntimeException");
      } catch (final RuntimeException e) {
        assertEquals("No DeltaIndexingManager is bound. Only valid DeltaIndexingType is "
          + DeltaIndexingType.DISABLED, e.getMessage());
      }
      try {
        contoller.doCheckForUpdate(DeltaIndexingType.INITIAL);
        fail("expected RuntimeException");
      } catch (final RuntimeException e) {
        assertEquals("No DeltaIndexingManager is bound. Only valid DeltaIndexingType is "
          + DeltaIndexingType.DISABLED, e.getMessage());
      }
      assertFalse(contoller.doCheckForUpdate(DeltaIndexingType.DISABLED));
    } finally {
      // reset delta indexing manager
      contoller.setDeltaIndexingManager(diManager);
    }
  }
}
