/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.datamodel.test;

import java.io.InputStream;
import java.util.Arrays;

import junit.framework.TestCase;

import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.InMemoryAttachment;

/** testcase for class {@link InMemoryAttachment}. */
public class TestInMemoryAttachment extends TestCase {

  /** test if exceptions for null arguments in constructor are thrown. */
  public void testArgumentValidation() throws Exception {
    try {
      new InMemoryAttachment(null, new byte[1]);
      fail("IllegalArgumentException expected for name == null");
    } catch (final IllegalArgumentException ex) {
      ; // ok
    }
    try {
      new InMemoryAttachment("null", null);
      fail("IllegalArgumentException expected for content == null");
    } catch (final IllegalArgumentException ex) {
      ; // ok
    }
  }

  /** test {@link InMemoryAttachment#getName()}. */
  public void testGetName() throws Exception {
    final String expectedName = "attachmentName";
    final InMemoryAttachment attachment = new InMemoryAttachment("attachmentName", new byte[1]);
    assertEquals(expectedName, attachment.getName());
  }

  /** test {@link InMemoryAttachment#size()}. */
  public void testSize() throws Exception {
    final int expectedSize = 42;
    InMemoryAttachment attachment = new InMemoryAttachment("test", new byte[expectedSize]);
    assertEquals(expectedSize, attachment.size());
    attachment = new InMemoryAttachment("test", new byte[0]);
    assertEquals(0, attachment.size());
  }

  /** test {@link InMemoryAttachment#getAsBytes()}. */
  public void testGetAsBytes() throws Exception {
    final int expectedSize = 42;
    final byte[] expectedContent = new byte[expectedSize];
    Arrays.fill(expectedContent, (byte) 'a');
    final InMemoryAttachment attachment = new InMemoryAttachment("test", expectedContent);
    final byte[] getAsBytes = attachment.getAsBytes();
    assertEquals(expectedSize, getAsBytes.length);
    assertTrue(Arrays.equals(expectedContent, getAsBytes));
  }

  /** test {@link InMemoryAttachment#getAsBytes()}. */
  public void testGetAsBytesLimited() throws Exception {
    final int expectedSize = 42;
    final byte[] expectedContent = new byte[expectedSize];
    Arrays.fill(expectedContent, (byte) 'a');
    final InMemoryAttachment attachment = new InMemoryAttachment("test", expectedContent);
    final byte[] getAsBytesHalf = attachment.getAsBytes(expectedSize / 2);
    assertEquals(expectedSize / 2, getAsBytesHalf.length);
    final byte[] getAsBytesDouble = attachment.getAsBytes(expectedSize * 2);
    assertEquals(expectedSize, getAsBytesDouble.length);
    assertTrue(Arrays.equals(expectedContent, getAsBytesDouble));
  }

  /** test {@link InMemoryAttachment#getAsStream()}. */
  public void testGetAsStream() throws Exception {
    final int expectedSize = 42;
    final byte[] expectedContent = new byte[expectedSize];
    Arrays.fill(expectedContent, (byte) 'a');
    final InMemoryAttachment attachment = new InMemoryAttachment("test", expectedContent);
    final InputStream getAsStream = attachment.getAsStream();
    assertNotNull(getAsStream);
    final byte[] readFromStream = IOUtils.toByteArray(getAsStream);
    assertEquals(expectedSize, readFromStream.length);
    assertTrue(Arrays.equals(expectedContent, readFromStream));
  }
}
