/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.datamodel.test;

import junit.framework.TestCase;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.validation.InvalidRecordException;
import org.eclipse.smila.datamodel.validation.RecordIdValidator;

/**
 * test {@link RecordIdValidator}.
 */
public class TestRecordIdValidator extends TestCase {

  private final RecordIdValidator _validator = new RecordIdValidator();

  /** test with valid record. */
  public void testOk() throws Exception {
    final Record record = DataFactory.DEFAULT.createRecord();
    record.getMetadata().put(Record.RECORD_ID, "id");
    _validator.validate(record);
  }

  /** test conversion of integer record. */
  public void testConvertId() throws Exception {
    final Record record = DataFactory.DEFAULT.createRecord();
    record.getMetadata().put(Record.RECORD_ID, 1);
    _validator.validate(record);
    final Any idValue = record.getMetadata().get(Record.RECORD_ID);
    assertTrue(idValue.isString());
    assertEquals("1", idValue.asValue().asString());
  }

  /** test with missing ID. */
  public void testMissingId() throws Exception {
    final Record record = DataFactory.DEFAULT.createRecord();
    try {
      _validator.validate(record);
      fail("should not work");
    } catch (final InvalidRecordException ex) {
      ; // fine.
    }
  }

  /** test with empty ID value. */
  public void testEmptyId() throws Exception {
    final Record record = DataFactory.DEFAULT.createRecord();
    record.getMetadata().put(Record.RECORD_ID, "");
    try {
      _validator.validate(record);
      fail("should not work");
    } catch (final InvalidRecordException ex) {
      ; // fine.
    }
  }

  /** test with sequence in ID attribute. */
  public void testSequenceId() throws Exception {
    final Record record = DataFactory.DEFAULT.createRecord();
    record.getMetadata().put(Record.RECORD_ID, DataFactory.DEFAULT.createAnySeq());
    try {
      _validator.validate(record);
      fail("should not work");
    } catch (final InvalidRecordException ex) {
      ; // fine.
    }
  }

  /** test with sequence in ID attribute. */
  public void testMapId() throws Exception {
    final Record record = DataFactory.DEFAULT.createRecord();
    record.getMetadata().put(Record.RECORD_ID, DataFactory.DEFAULT.createAnyMap());
    try {
      _validator.validate(record);
      fail("should not work");
    } catch (final InvalidRecordException ex) {
      ; // fine.
    }
  }

}
