/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.datamodel.validation;

/**
 * thrown by RecordValidator to denote that a record does not conform to the index schema.
 * 
 * @author jschumacher
 * 
 */
public class InvalidRecordException extends Exception {
  /**
   * exceptions are serializable.
   */
  private static final long serialVersionUID = 1L;

  /**
   * create exception.
   * 
   * @param message
   *          details
   * @param cause
   *          reason
   */
  public InvalidRecordException(final String message, final Throwable cause) {
    super(message, cause);
  }

  /**
   * create exception.
   * 
   * @param message
   *          details
   */
  public InvalidRecordException(final String message) {
    super(message);
  }

}
