/*********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.importing.crawler.file.test;

import java.io.File;
import java.io.IOException;

import org.apache.commons.io.FileUtils;

/**
 * Helper class that creates a folder structure for testing.
 * 
 * @author stuc07
 * 
 */
public final class FileystemHelper {

  public static File initTestFilesystem() throws IOException {
    File rootFolder = File.createTempFile("importing", "crawler");
    final String path = rootFolder.getPath();
    rootFolder.delete();
    rootFolder = new File(path);

    final File folderA = new File(rootFolder, "a");
    new File(folderA, "aa").mkdirs();
    new File(folderA, "ab").mkdirs();
    new File(rootFolder, "b").mkdirs();
    FileUtils.touch(new File(rootFolder, "c"));
    FileUtils.touch(new File(rootFolder, "d.e"));

    return rootFolder;
  }
}
