/*********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.importing.crawler.file.test;

import java.io.File;
import java.util.Collection;

import org.apache.commons.io.FileUtils;
import org.eclipse.smila.importing.crawler.file.FileCrawlerService;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

public class TestFileCrawlerService extends DeclarativeServiceTestCase {

  private File _rootFolder;

  @Override
  public void setUp() throws Exception {
    _rootFolder = FileystemHelper.initTestFilesystem();
  }

  @Override
  public void tearDown() throws Exception {
    if (_rootFolder != null) {
      FileUtils.deleteDirectory(_rootFolder);
    }
  }

  public void testService() throws Exception {
    getFileCrawlerService();
  }

  public void testListFiles() throws Exception {
    final FileCrawlerService fileCrawler = getFileCrawlerService();
    final Collection<File> files = fileCrawler.listFiles(_rootFolder);
    assertNotNull(files);
    assertEquals(2, files.size());
    assertTrue(files.contains(new File(_rootFolder, "c")));
    assertTrue(files.contains(new File(_rootFolder, "d.e")));
  }

  public void testListDirectoriess() throws Exception {
    final FileCrawlerService fileCrawler = getFileCrawlerService();
    final Collection<File> dirs = fileCrawler.listDirectories(_rootFolder);
    assertNotNull(dirs);
    assertEquals(2, dirs.size());
    assertTrue(dirs.contains(new File(_rootFolder, "a")));
    assertTrue(dirs.contains(new File(_rootFolder, "b")));

    final Collection<File> subDirs = fileCrawler.listDirectories(new File(_rootFolder, "a"));
    assertNotNull(subDirs);
    assertEquals(2, subDirs.size());
    assertTrue(subDirs.contains(new File(_rootFolder, "a/aa")));
    assertTrue(subDirs.contains(new File(_rootFolder, "a/ab")));
  }

  private FileCrawlerService getFileCrawlerService() throws Exception {
    final FileCrawlerService fileCrawler = getService(FileCrawlerService.class);
    assertNotNull(fileCrawler);
    return fileCrawler;
  }
}
