/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.importing.state.objectstore.test;

import java.util.Collection;

import org.eclipse.smila.importing.VisitedLinksService;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

/**
 * Unit test cases for the ObjectStore based VisitedLinksService implementation.
 */
public class TestObjectStoreVisitedLinksService extends DeclarativeServiceTestCase {
  /** the service under test. */
  private VisitedLinksService _service;

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _service = getService(VisitedLinksService.class);
    _service.clearAll();
  }

  /** test checking of new objects. */
  public void testCheckNewObject() throws Exception {
    final String recordId = "testCheckNewObject";
    assertEquals(false, _service.isVisited("s", recordId, "j1", "h1"));
    // still new after repeats.
    assertEquals(false, _service.isVisited("s", recordId, "j1", "h1"));
  }

  /** test adding of new objects. */
  public void testAddNewObject() throws Exception {
    final String recordId = "testAddNewObject";
    _service.markAsVisited("s", recordId, "j1", "h1");
    assertEquals(false, _service.isVisited("s", recordId, "j1", "h1"));
    assertEquals(true, _service.isVisited("s", recordId, "j1", "h2"));
  }

  /** test updating objects objects. */
  public void testUpdateObject() throws Exception {
    final String recordId = "testUpdateObject";
    _service.markAsVisited("s", recordId, "j1", "h1");
    // next job run
    assertEquals(false, _service.isVisited("s", recordId, "j2", "h2"));
    _service.markAsVisited("s", recordId, "j2", "h2");
    assertEquals(false, _service.isVisited("s", recordId, "j2", "h2"));
  }

  /** test clearing a single source. */
  public void testClearSource() throws Exception {
    final String recordId = "testClearSource";
    _service.markAsVisited("s1", recordId, "j1", "h1");
    _service.markAsVisited("s2", recordId, "j1", "h1");
    _service.clearSource("s1");
    assertEquals(false, _service.isVisited("s1", recordId, "j1", "h1"));
    assertEquals(false, _service.isVisited("s2", recordId, "j1", "h1"));
    assertEquals(true, _service.isVisited("s2", recordId, "j1", "h2"));
  }

  /** test clearing the complete delta service. */
  public void testClearAll() throws Exception {
    final String recordId = "testClearAll";
    _service.markAsVisited("s1", recordId, "j1", "h1");
    _service.markAsVisited("s2", recordId, "j1", "h1");
    _service.clearAll();
    assertEquals(false, _service.isVisited("s1", recordId, "j1", "h1"));
    assertEquals(false, _service.isVisited("s2", recordId, "j1", "h1"));
  }

  /** test getting source ids. */
  public void testGetSourceIdsInitial() throws Exception {
    final Collection<String> sourceIds = _service.getSourceIds();
    assertTrue(sourceIds.isEmpty());
  }

  /** test getting source ids. */
  public void testGetSourceIds() throws Exception {
    final String recordId = "testGetSourceIds";
    _service.markAsVisited("s1", recordId, "j1", "h1");
    _service.markAsVisited("s2", recordId, "j1", "h1");
    Collection<String> sourceIds = _service.getSourceIds();
    assertEquals(2, sourceIds.size());
    assertTrue(sourceIds.contains("s1"));
    assertTrue(sourceIds.contains("s2"));
    _service.clearSource("s1");
    sourceIds = _service.getSourceIds();
    assertEquals(1, sourceIds.size());
    assertTrue(sourceIds.contains("s2"));
    _service.clearSource("s2");
    sourceIds = _service.getSourceIds();
    assertTrue(sourceIds.isEmpty());
  }

}
