/*********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.importing.test;

import org.eclipse.smila.bulkbuilder.BulkbuilderService;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.importing.DeltaService;
import org.eclipse.smila.jobmanager.JobRunDataProvider;
import org.eclipse.smila.jobmanager.JobRunEngine;
import org.eclipse.smila.jobmanager.JobState;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.JobManagerConstants;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

public abstract class AImportingIntegrationTest extends DeclarativeServiceTestCase {

  protected static final String JOBNAME_BUILDBULKS = "buildBulks";

  protected static final String STORENAME_BULKS = "bulks";

  protected static final String BUCKET_ADDED = "addedRecords";

  protected JobRunEngine _jobRunEngine;

  protected JobRunDataProvider _jobRunDataProvider;

  protected DefinitionPersistence _defPersistence;

  protected ObjectStoreService _objectStore;

  protected DeltaService _deltaService;

  protected BulkbuilderService _bulkbuilder;

  private String _jobIdBuildBulks;

  public AImportingIntegrationTest() {
    super();
  }

  @Override
  protected void setUp() throws Exception {
    super.setUp();

    _objectStore = getService(ObjectStoreService.class);
    _objectStore.ensureStore(STORENAME_BULKS);
    _objectStore.clearStore(STORENAME_BULKS);

    _deltaService = getService(DeltaService.class);
    _deltaService.clearAll();

    _jobRunEngine = getService(JobRunEngine.class);
    _jobRunDataProvider = getService(JobRunDataProvider.class);
    _defPersistence = getService(DefinitionPersistence.class);
    _jobIdBuildBulks = _jobRunEngine.startJob(JOBNAME_BUILDBULKS);

    _bulkbuilder = getService(BulkbuilderService.class);
  }

  @Override
  protected void tearDown() throws Exception {
    _jobRunEngine.finishJob(JOBNAME_BUILDBULKS, _jobIdBuildBulks);
    waitForJobRunCompleted(JOBNAME_BUILDBULKS, _jobIdBuildBulks, 5000);
    super.tearDown();
  }

  /**
   * Waits for a job to be completed.
   */
  protected void waitForJobRunCompleted(final String jobName, final String jobId, final long maxWaitTime)
    throws Exception {
    final long sleepTime = 500L;
    final long millisStarted = System.currentTimeMillis();
    while (true) {
      final AnyMap runData = _jobRunDataProvider.getJobRunData(jobName, jobId);
      final String jobRunState = runData.getStringValue(JobManagerConstants.DATA_JOB_STATE);
      if (jobRunState != null) {
        final JobState state = JobState.valueOf(jobRunState);
        assertNotSame(JobState.FAILED, state);
        if (state == JobState.SUCCEEDED) {
          return; // finally found what we're waiting for.
        }
      }
      assertTrue("Waited too long for job to complete", System.currentTimeMillis() - millisStarted <= maxWaitTime);
      Thread.sleep(sleepTime);
    }
  }

}
