/***********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH.  
 * All rights reserved. This program and the accompanying materials are made available
 * under the terms of the Eclipse Public License v1.0 which accompanies this distribution, 
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial API and implementation               
 **********************************************************************************************************************/

package org.eclipse.smila.ipc.bon;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.eclipse.smila.ipc.IpcFactory;

/**
 * Factory for stream readers/writers using a binary object notation (BON). See <a href=
 * "http://wiki.eclipse.org/SMILA/Documentation/Data_Model_and_Serialization_Formats#BON_Binary_Object_Notation_Format">
 * http://wiki.eclipse.org/SMILA/Documentation/Data_Model_and_Serialization_Formats#BON_Binary_Object_Notation_Format
 * </a> for specification.
 * 
 * @author aweber
 * 
 */
public class BinaryFactory implements IpcFactory {

  /**
   * create a new BON stream reader. {@inheritDoc}
   */
  @Override
  public BinaryStreamReader newStreamReader(final InputStream stream) throws IOException {
    return new BinaryStreamReader(stream);
  }

  /**
   * create a new BON stream writer. {@inheritDoc}
   */
  @Override
  public BinaryStreamWriter newStreamWriter(final OutputStream stream) throws IOException {
    return new BinaryStreamWriter(stream);
  }

}
