/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.test;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.util.RequestHandler;
import org.eclipse.smila.jobmanager.definitions.JobManagerConstants;
import org.eclipse.smila.jobmanager.httphandler.DataObjectTypeHandler;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

/**
 * Test cases for the {@link DataObjectTypeHandler}.
 */
public class TestDataObjectTypeHandler extends DeclarativeServiceTestCase {

  private DataObjectTypeHandler _dotHandler;

  /** {@inheritDoc} */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
    final RequestHandler service =
      getService(RequestHandler.class, "(uriPattern=/jobmanager/dataobjecttypes/\\([^/]+\\)/?$)");
    assertTrue(service instanceof DataObjectTypeHandler);
    _dotHandler = (DataObjectTypeHandler) service;
  }

  /** {@inheritDoc} */
  @Override
  protected void tearDown() throws Exception {
    super.tearDown();
  }

  /**
   * tests getting a definition via the request handler.
   * 
   * @throws Exception
   */
  public void testGetDefinition() throws Exception {
    final String jobBaseUrlPart = _dotHandler.getRootContextPath() + "/jobmanager/dataobjecttypes/";
    final String definitionName = "wrongType";
    // get the complete definition
    final Record returnDetails = DataFactory.DEFAULT.createRecord();
    returnDetails.getMetadata().put(JobManagerConstants.KEY_RETURN_DETAILS, true);
    AnyMap retrievedDefinition =
      (AnyMap) _dotHandler.process("GET", jobBaseUrlPart + definitionName, returnDetails);
    // check the comments field.
    assertEquals("my comment", retrievedDefinition.getStringValue("comment"));
    // get only the relevant part
    retrievedDefinition = (AnyMap) _dotHandler.process("GET", jobBaseUrlPart + definitionName, null);
    assertFalse(retrievedDefinition.containsKey("comment"));
  }
}
