package org.eclipse.smila.jobmanager.test;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.definitions.Bucket;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.exceptions.PersistenceException;
import org.eclipse.smila.jobmanager.taskgenerator.RunOnceTriggerTaskGenerator;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGenerator;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorException;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorProvider;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

/**
 * Tests the {@link RunOnceTriggerTaskGenerator}.
 */
public class TestRunOnceTriggerTaskGenerator extends DeclarativeServiceTestCase {

  /** the task generator to test. */
  private TaskGenerator _taskGenerator;

  /** the definition persistence which provides us with buckets etc. */
  private DefinitionPersistence _definitionPersistence;

  /** {@inheritDoc} */
  @Override
  protected void setUp() throws Exception {
    super.setUp();

    final TaskGeneratorProvider taskGeneratorProvider = getService(TaskGeneratorProvider.class);
    assertNotNull(taskGeneratorProvider);
    _taskGenerator = taskGeneratorProvider.getTaskGenerator("runOnceTrigger");
    assertNotNull(_taskGenerator);
    assertTrue(_taskGenerator instanceof RunOnceTriggerTaskGenerator);
    _definitionPersistence = getService(DefinitionPersistence.class);
    assertNotNull(_definitionPersistence);
  }

  /** {@inheritDoc} */
  @Override
  protected void tearDown() throws Exception {
    super.tearDown();
  }

  /**
   * Test {@link RunOnceTriggerTaskGenerator}'s createRunOnceTasks method.
   * 
   * @throws TaskGeneratorException
   * @throws PersistenceException
   */
  public void testCreateRunOnceTasks() throws TaskGeneratorException, PersistenceException {
    final AnyMap parameters = DataFactory.DEFAULT.createAnyMap();
    final String paramStore = "tempStore";
    final String param2 = "param2";
    final String storeName = "temStore";
    final String key2 = "key2";
    final String slot1 = "slot1";
    final String slot2 = "slot2";
    final String inputSlot = "inputslot";
    final String bucketName1 = "triggeredBucket";
    final String bucketName2 = "processedBucket";
    final String bucketName3 = "inBucket";
    final String dataObjectType = "recordBulks";
    final String workerName = "dummyWorker";
    parameters.put(paramStore, storeName);
    parameters.put(param2, key2);
    final Map<String, Bucket> outputBuckets = new HashMap<String, Bucket>();

    outputBuckets.put(
      slot1,
      new Bucket(_definitionPersistence.getBucket(bucketName1), _definitionPersistence
        .getDataObjectType(dataObjectType), false, parameters));

    outputBuckets.put(
      slot2,
      new Bucket(_definitionPersistence.getBucket(bucketName2), _definitionPersistence
        .getDataObjectType(dataObjectType), false, parameters));
    final Map<String, Bucket> inputBuckets = new HashMap<String, Bucket>();

    inputBuckets.put(
      inputSlot,
      new Bucket(_definitionPersistence.getBucket(bucketName3), _definitionPersistence
        .getDataObjectType(dataObjectType), false, parameters));
    final List<Task> taskList1 = _taskGenerator.createRunOnceTasks(null, outputBuckets, parameters, workerName);
    for (final Task task : taskList1) {
      assertEquals(workerName, task.getWorkerName());
      assertEquals(null, task.getQualifier());
      assertEquals(0, task.getInputBulks().size());
      assertEquals(1, task.getOutputBulks().get(slot1).size());
      assertEquals(bucketName1, task.getOutputBulks().get(slot1).get(0).getBucketName());
      assertEquals(storeName, task.getOutputBulks().get(slot1).get(0).getStoreName());
      assertEquals(1, task.getOutputBulks().get(slot2).size());
      assertEquals(bucketName2, task.getOutputBulks().get(slot2).get(0).getBucketName());
      assertEquals(storeName, task.getOutputBulks().get(slot2).get(0).getStoreName());
      assertEquals(parameters, task.getParameters());
    }
    // input buckets won't matter...
    final List<Task> taskList2 =
      _taskGenerator.createRunOnceTasks(inputBuckets, outputBuckets, parameters, workerName);
    for (final Task task : taskList2) {
      assertEquals(workerName, task.getWorkerName());
      assertEquals(null, task.getQualifier());
      // still the input is ignored here!
      assertEquals(0, task.getInputBulks().size());
      assertEquals(1, task.getOutputBulks().get(slot1).size());
      assertEquals(bucketName1, task.getOutputBulks().get(slot1).get(0).getBucketName());
      assertEquals(storeName, task.getOutputBulks().get(slot1).get(0).getStoreName());
      assertEquals(1, task.getOutputBulks().get(slot2).size());
      assertEquals(bucketName2, task.getOutputBulks().get(slot2).get(0).getBucketName());
      assertEquals(storeName, task.getOutputBulks().get(slot2).get(0).getStoreName());
      assertEquals(parameters, task.getParameters());
    }
  }

}
