/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.jobmanager.test.worker;

import java.util.Date;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.Inputs;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.Outputs;
import org.eclipse.smila.taskworker.output.RecordOutput;

/**
 * Test worker that checks complex configurations.
 */
public class TestComplexParametersWorker implements Worker {

  public static final AnyMap EXPECTED_MAP = DataFactory.DEFAULT.createAnyMap();

  public static final String NAME = "testComplexParameters";

  public static final String OUTPUT_ATTRIBUTE = "testComplexParametersOut";

  public static final String INPUT_SLOT_NAME = "input";

  public static final String OUTPUT_SLOT_NAME = "output";

  static {
    // beware! do not change anything here unless you change the test in TestComplexParametersInJob!
    final AnyMap map = DataFactory.DEFAULT.createAnyMap();
    final AnySeq seq = DataFactory.DEFAULT.createAnySeq();
    map.put("a", "a");
    map.put("l", Long.MAX_VALUE);
    map.put("b", true);
    map.add("d", DataFactory.DEFAULT.createDoubleValue(Double.MIN_VALUE));
    map.add("d", DataFactory.DEFAULT.createDoubleValue(Double.MAX_VALUE));
    seq.add(map);
    seq.add(DataFactory.DEFAULT.createDateValue(new Date()));
    EXPECTED_MAP.put("seq", seq);
    final AnyMap mapInMap = DataFactory.DEFAULT.createAnyMap();
    mapInMap.put("dateTime", DataFactory.DEFAULT.createDateTimeValue(new Date()));
    EXPECTED_MAP.put("mapInMap", mapInMap);
    EXPECTED_MAP.put("mapBloodyMap", mapInMap);
    final AnyMap crapMap = DataFactory.DEFAULT.createAnyMap();
    crapMap.put("l", Long.MAX_VALUE);
    EXPECTED_MAP.put("crapMap", crapMap);
    EXPECTED_MAP.put("d", 2.0);
    EXPECTED_MAP.put("dMin", Double.MIN_VALUE);
    final AnyMap yetAnotherMap = DataFactory.DEFAULT.createAnyMap();
    yetAnotherMap.put("key", "value");
    EXPECTED_MAP.put("yetAnotherMap", yetAnotherMap);
  }

  /**
   * default constructor used when getting OSGI service instance.
   */
  public TestComplexParametersWorker() {
  }

  /** {@inheritDoc} */
  @Override
  public void perform(final TaskContext taskContext) {
    final Task task = taskContext.getTask();
    AnyMap taskParam;
    if (task != null && task.getParameters() != null) {
      taskParam = task.getParameters().getMap("map");
    } else {
      taskParam = null;
    }
    try {
      final Inputs inputs = taskContext.getInputs();
      final RecordInput recordInput = inputs.getAsRecordInput(INPUT_SLOT_NAME);
      final Outputs outputs = taskContext.getOutputs();
      final RecordOutput recordOutput = outputs.getAsRecordOutput(OUTPUT_SLOT_NAME);
      Record record = recordInput.getRecord();
      while (record != null) {
        try {
          record.getMetadata().put(OUTPUT_ATTRIBUTE, taskParam);
          recordOutput.writeRecord(record);
          record = recordInput.getRecord();
        } catch (final Exception e) {
          record = null;
        }
      }
    } catch (final Exception e) {
      e.printStackTrace();
    }
  }

  /** {@inheritDoc} */
  @Override
  public String getName() {
    return NAME;
  }

}
