/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.objectstore.test;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Suite combining the Eclipse SMILA objectstore bundle tests.
 * 
 */
public final class AllTests {

  public static final String BUNDLE_ID = "org.eclipse.smila.objectstore.test"; 
  /**
   * utility class, do not create instances.
   */
  private AllTests() {
    ; // nothing
  }

  /**
   * @return the test suite containing all tests for the objectstore bundle.
   */
  public static Test suite() {
    final TestSuite suite = new TestSuite(AllTests.class.getName());
    // $JUnit-BEGIN$
    suite.addTestSuite(TestObjectStoreServiceHandler.class);
    suite.addTestSuite(TestStoreAdminHandler.class);
    suite.addTestSuite(TestStoreObjectHandler.class);
    // $JUnit-END$
    return suite;
  }

}
