/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.processing.bpel.test;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.processing.WorkflowProcessor;
import org.eclipse.smila.processing.bpel.internal.ObjectStoreWorkflowStorage;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

/**
 * Test for {@link ObjectStoreWorkflowStorage} class.
 * 
 * @author aweber
 */
public class TestWorkflowStorage extends DeclarativeServiceTestCase {

  private static final String WORKFLOW_STORE = "workflows";

  private ObjectStoreWorkflowStorage _workflowStorage;

  private ObjectStoreService _objectStore;

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _objectStore = getService(ObjectStoreService.class);
    assertNotNull(_objectStore);
    _objectStore.removeStore(WORKFLOW_STORE);
    _workflowStorage = new ObjectStoreWorkflowStorage();
    _workflowStorage.setObjectStore(_objectStore);
    _workflowStorage.setStoreName(WORKFLOW_STORE);
  }

  /** tests adding, updating and removing of workflows. */
  public void test() throws Exception {
    assertFalse("Store should not exist when test starts", _objectStore.existsStore(WORKFLOW_STORE));
    assertTrue(_workflowStorage.getWorkflowNames().isEmpty());
    assertTrue("Store should now exist", _objectStore.existsStore(WORKFLOW_STORE));

    _workflowStorage.setWorkflow("wf1", createWorkflowDefinition("wf1", "1"));
    _workflowStorage.setWorkflow("wf2", createWorkflowDefinition("wf2", "2"));
    assertTrue(_workflowStorage.getWorkflowNames().contains("wf1"));
    assertTrue(_workflowStorage.getWorkflowNames().contains("wf2"));
    assertEquals(_workflowStorage.getWorkflow("wf1").getStringValue(WorkflowProcessor.WORKFLOW_DEFINITION), "1");
    assertEquals(_workflowStorage.getWorkflow("wf2").getStringValue(WorkflowProcessor.WORKFLOW_DEFINITION), "2");
    assertEquals(_objectStore.getStoreObjectInfos(WORKFLOW_STORE).size(), 2);

    _workflowStorage.setWorkflow("wf1", createWorkflowDefinition("wf1", "1.1"));
    assertEquals(_workflowStorage.getWorkflow("wf1").getStringValue(WorkflowProcessor.WORKFLOW_DEFINITION), "1.1");

    _workflowStorage.deleteWorkflow("wf2");
    assertFalse(_workflowStorage.getWorkflowNames().contains("wf2"));
    assertNull(_workflowStorage.getWorkflow("wf2"));
    assertEquals(_objectStore.getStoreObjectInfos(WORKFLOW_STORE).size(), 1);
  }

  /** helper method to create workflow definition. */
  private AnyMap createWorkflowDefinition(final String workflowName, final String workflowContent) {
    final AnyMap workflowDef = DataFactory.DEFAULT.createAnyMap();
    workflowDef.put(WorkflowProcessor.WORKFLOW_NAME, workflowName);
    workflowDef.put(WorkflowProcessor.WORKFLOW_DEFINITION, workflowContent);
    return workflowDef;
  }
}
