/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank, Andreas Weber, Juergen Schumacher (Attensity Europe GmbH) - implementation
 *******************************************************************************/
package org.eclipse.smila.processing.worker.test;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Tests for org.eclipse.smila.processing.worker bundle.
 * 
 * @author aweber
 */
public final class AllTests {
  /**
   * utility class, do not create instances.
   */
  private AllTests() {
  }

  /**
   * @return suite for all pipeline worker tests
   */
  public static Test suite() {
    final TestSuite suite = new TestSuite("Test for org.eclipse.smila.processing.worker");
    // $JUnit-BEGIN$
    suite.addTestSuite(TestPipelineProcessorWorker.class);
    suite.addTestSuite(TestFilterPipeline.class);
    suite.addTestSuite(TestPipeletProcessorWorker.class);
    suite.addTestSuite(TestPipelineProcessorWorker2.class);
    // $JUnit-END$
    return suite;
  }
}
