/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Drazen Cindric (Attensity Europe GmbH) - implementation
 *******************************************************************************/
package org.eclipse.smila.processing.worker.test;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.worker.PipeletProcessorWorker;

/**
 * Pipelet for testing the {@link PipeletProcessorWorker}.
 */
public class PipeletProcessorWorkerTestPipelet implements Pipelet {

  public static final String ATTRIBUTE_NAME = "testAttribute";

  public static final String TEST_TEXT = "PipeletProcessorWorkerTestPipelet was here";

  public static boolean s_throwExceptions = true;

  @Override
  public String[] process(final Blackboard blackboard, final String[] recordIds) throws ProcessingException {
    try {
      for (final String id : recordIds) {
        final AnyMap metadata = blackboard.getMetadata(id);
        metadata.put(ATTRIBUTE_NAME, TEST_TEXT);
      }
    } catch (final Exception ex) {
      throw new ProcessingException(ex);
    }
    return recordIds;
  }

  @Override
  public void configure(final AnyMap configuration) throws ProcessingException {
    ; // nothing to do
  }

}
