/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.solr;

import java.text.MessageFormat;
import java.util.List;

import junit.framework.TestCase;

import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.DataFactoryCreator;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.search.api.helper.ResultBuilder;
import org.eclipse.smila.search.api.helper.ResultItemAccessor;
import org.eclipse.smila.solr.search.SolrSearchPipelet;

/**
 * The Class SolrSearchPipelet_AddResultRecords_Test.
 * 
 * @author tmenzel
 */
public class SolrSearchPipelet_AddResultRecords_Test extends TestCase {

  /** The logger. */
  private final org.apache.commons.logging.Log _log = org.apache.commons.logging.LogFactory.getLog(this.getClass());

  /** The _pipelet. */
  SolrSearchPipelet _pipelet = new SolrSearchPipelet();

  private Record _queryRecord;

  private ResultBuilder _resultBuilder;

  /**
   */
  @Override
  protected void setUp() throws Exception {
    _queryRecord = DataFactoryCreator.createDefaultFactory().createRecord();

    _resultBuilder = new ResultBuilder("dummy", _queryRecord);

  }

  public void test_Info() {
    _log.info("Tests are disabled because of new SolrResultBuilder.");
  }

  // /**
  // * Tests the various cases where id is not set as expected.
  // */
  // public void test_SolrResponse2SearchMessage_Fail_IdHasProblems() throws Exception {
  // // test case: id field missing
  // final SolrDocumentList solrResults = new SolrDocumentList();
  //
  // _log.debug("test");
  // final SolrDocument solrDocument = new SolrDocument();
  // solrDocument.setField(SolrConstants.CORE_FIELD_SCORE, 0.0);
  // solrResults.add(solrDocument);
  //
  // try {
  // _pipelet.addResultRecords(solrResults, _resultBuilder);
  // } catch (ProcessingException e) {
  // _log.debug("exception under test: case: id field missing: ", e);
  // }
  //
  // // test case: id field value is null
  // solrDocument.setField(SolrConstants.CORE_FIELD_ID, null);
  // // solrResults.add(solrDocument);
  //
  // try {
  // _pipelet.addResultRecords(solrResults, _resultBuilder);
  // } catch (ProcessingException e) {
  // _log.debug("exception under test: case: id field value null: ", e);
  // }
  //
  // }

  // /**
  // * Tests the various cases where score is not set as expected. however, these cases are just logged hence u need to
  // * manually check the log for these messages
  // */
  // public void test_SolrResponse2SearchMessage_Fail_ScoreHasProblems() throws Exception {
  // // test case: id field missing
  // final SolrDocumentList solrResults = new SolrDocumentList();
  //
  // final SolrDocument solrDocument = new SolrDocument();
  // solrDocument.setField(SolrConstants.CORE_FIELD_ID, getName());
  // solrResults.add(solrDocument);
  //
  // // missing score
  // _log.warn("exception under test: case: score field missing: ");
  // _pipelet.addResultRecords(solrResults, _resultBuilder);
  //
  // _log.warn("exception under test: case: score field not a number: ");
  // solrDocument.setField(SolrConstants.CORE_FIELD_SCORE, "asds");
  // _pipelet.addResultRecords(solrResults, _resultBuilder);
  //
  // }

  // /**
  // * tests if returned data types are properly converted from solr to smila
  // */
  // public void test_SolrResponse2SearchMessage_DataTypes() throws Exception {
  // _log.info("##################### Test: " + getName());
  //
  // final SolrDocumentList solrResults = new SolrDocumentList();
  // solrResults.setNumFound(3);
  // solrResults.setStart(5);
  //
  // final SolrDocument solrDocument = new SolrDocument();
  // final String id = super.getName();
  // solrDocument.setField(SolrConstants.CORE_FIELD_ID, id);
  // solrDocument.setField(SolrConstants.CORE_FIELD_SCORE, 3.0f);
  //
  // solrDocument.setField("Id", id);
  // solrDocument.setField("string", "string");
  // solrDocument.setField("boolean", true);
  // solrDocument.setField("int", Integer.MAX_VALUE);
  // solrDocument.setField("long", Long.MAX_VALUE);
  // solrDocument.setField("float", Float.MAX_VALUE);
  // solrDocument.setField("double", Double.MAX_VALUE);
  // solrDocument.setField("date", dateValue);
  // solrResults.add(solrDocument);
  //
  // solrDocument.setField("strings", Arrays.asList("s1, s2".split(" ")));
  // solrDocument.setField("longs", Arrays.asList(new Long[] { 1L, 3L, 5L }));
  // solrDocument.setField("doubles", Arrays.asList(new Double[] { 1.1, 1.3, -1.5 }));
  //
  // _pipelet.addResultRecords(solrResults, _resultBuilder);
  // final ResultAccessor resultAccessor = new ResultAccessor("dummy workflow", _queryRecord);
  // final ResultItemAccessor resultItem = resultAccessor.getResultRecord(0);
  //
  // assertNotNull(resultItem);
  // assertRecordAttributeValue(resultItem, "string", "string");
  // assertRecordAttributeValue(resultItem, "boolean", true);
  // assertRecordAttributeValue(resultItem, "int", (long) Integer.MAX_VALUE);
  // assertRecordAttributeValue(resultItem, "long", Long.MAX_VALUE);
  // assertRecordAttributeValue(resultItem, "float", (double) Float.MAX_VALUE);
  // assertRecordAttributeValue(resultItem, "double", Double.MAX_VALUE);
  // assertRecordAttributeValue(resultItem, "date", dateValue);
  //
  // assertRecordAttributeValues(resultItem, "strings", Arrays.asList("s1, s2".split(" ")));
  // assertRecordAttributeValues(resultItem, "longs", Arrays.asList(new Long[] { 1L, 3L, 5L }));
  // assertRecordAttributeValues(resultItem, "doubles", Arrays.asList(new Double[] { 1.1, 1.3, -1.5 }));
  //
  // _log.debug(XmlSerializationUtils.serialize2string(_queryRecord));
  // }

  /**
   * @param resultItem
   * @param string
   * @param split
   * @throws BlackboardAccessException
   */
  private void assertRecordAttributeValues(ResultItemAccessor resultItem, String attributeName, List<?> list)
    throws BlackboardAccessException {
    final Any any = resultItem.getMetadata().get(attributeName);
    assertNotNull("Any missing for: " + attributeName, any);
    assertTrue("the value must be a seq. but is: " + any.getValueType(), any.isSeq());

    for (int j = 0; j < list.size(); j++) {
      final Object value = any.asSeq().get(j).asValue().getObject();
      assertEquals(MessageFormat.format("values differ for: {0}[{1}]", attributeName, j), value, list.get(j));
      j++;
    }
  }

  /**
   */
  private void assertRecordAttributeValue(final ResultItemAccessor resultItem, Object attributeName,
    Object expectedValue) {
    final Any any = resultItem.getMetadata().get(attributeName);
    assertNotNull("Any missing for: " + attributeName, any);

    final Object value = any.asValue().getObject();
    assertEquals("values differ for: " + attributeName, value, expectedValue);
  }

}
