/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.solr;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.xml.XmlSerializationUtils;
import org.eclipse.smila.solr.search.SolrResultAccessor;
import org.eclipse.smila.solr.util.TermsQueryConfigAdapter;

/**
 * 
 * @author tmenzel
 */
public class SolrSearchPipelet_AutoComplete_Test extends SolrSearchPipeletTestBase {

  /**
   */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _solrField = "attr_" + getName(); // textgen type so there is no analyzing but still splitting
  }

  /**
   * simple case to ensure that this works as written in the wiki.
   */
  public void test_Simple() throws Exception {
    // index docs
    addSolrDoc("1", "containing conjugate camera");
    addSolrDoc("2", "containing congratulations canyon containing");
    indexAndCommit();

    // setup search
    final TermsQueryConfigAdapter terms = new TermsQueryConfigAdapter(_solrField);
    terms.setTermsPrefix("con");
    _queryBuilder.setTermsConfiguration(terms);
    _queryBuilder.setRequestHandler("/terms");

    _pipelet.process(_blackboard, new String[] { _record.getId() });
    _log.debug("result record: " + XmlSerializationUtils.serialize2string(_record));

    // verify
    final SolrResultAccessor results = new SolrResultAccessor(WORKFLOW, _record);
    final AnyMap termsResult = results.getTermsResult();
    assertEquals(3, termsResult.size());
    assertTrue(termsResult.containsKey("containing"));
    assertTrue(termsResult.containsKey("conjugate"));
    assertTrue(termsResult.containsKey("congratulations"));

  }

}
