/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.solr;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.xml.XmlSerializationUtils;
import org.eclipse.smila.solr.search.SolrResultAccessor;
import org.eclipse.smila.solr.util.SpellCheckQueryConfigAdapter;

/**
 * 
 * @author tmenzel
 */
public class SolrSearchPipelet_DidYouMean_Test extends SolrSearchPipeletTestBase {

  /**
   */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _solrField = "Content";
  }

  /**
   * simple case to ensure that this works as written in the wiki.
   */
  public void test_Simple() throws Exception {
    // index docs
    addSolrDoc("1",
      "This is a simple text without real meaning as i dont want to bust my behind for smth. with more sense.");
    addSolrDoc("2", "It is just used for testing.");
    indexAndCommit();

    // setup search
    final SpellCheckQueryConfigAdapter spellcheck = new SpellCheckQueryConfigAdapter();
    spellcheck.setSpellCheckCount(5);
    spellcheck.setSpellCheckExtendedResults(true);
    spellcheck.setSpellCheckCollate(true);
    _queryBuilder.setSpellCheckConfiguration(spellcheck);
    _queryBuilder.setQuery("Content:rust");

    _pipelet.process(_blackboard, new String[] { _record.getId() });
    _log.debug("result record: " + XmlSerializationUtils.serialize2string(_record));

    // verify
    final SolrResultAccessor results = new SolrResultAccessor(WORKFLOW, _record);
    final AnyMap spellResult = results.getSpellCheckResult();
    assertEquals(2, spellResult.size());
    final AnyMap rustSuggestions = spellResult.getMap("rust");
    assertEquals(2, rustSuggestions.size());
    assertEquals(1, rustSuggestions.getLongValue("just").longValue());
    assertEquals(1, rustSuggestions.getLongValue("bust").longValue());
    assertEquals("Content:just", spellResult.getStringValue("collation"));

  }

}
