/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.solr;

import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.solr.search.SolrResultAccessor;

/** Tests conversion of search filter. */
public class SolrSearchPipelet_Filter_OnBounds_Test extends SolrSearchPipeletTestBase {

  private AnySeq _resultRecords;

  @Override
  protected void setUp() throws Exception {
    super.setUp();

    _solrField = getName() + "_tl";
    addSolrDoc("0", _solrField, "-2");
    addSolrDoc("1", _solrField, "-1");
    addSolrDoc("2", _solrField, "2");
    addSolrDoc("3", _solrField, "3");

    _queryBuilder.setQuery("*:*");
    _queryBuilder.setResultAttributes(_solrField);
    indexAndCommit();

  }

  /**
   */
  public void test_AtLeast() throws Exception {
    // setup
    _queryBuilder.addAtLeastFilter(_solrField, -1);

    // run
    execSearch();

    // verify
    SolrTestUtils.assertResultIds(_resultRecords, 1, 2, 3);

  }

  /**
   */
  public void test_Greater() throws Exception {
    // setup
    _queryBuilder.addGreaterThanFilter(_solrField, -1);

    // run
    execSearch();

    // verify
    SolrTestUtils.assertResultIds(_resultRecords, 2, 3);

  }

  /**
   */
  public void test_Less() throws Exception {
    // setup
    _queryBuilder.addLessThanFilter(_solrField, 2);

    // run
    execSearch();

    // verify
    SolrTestUtils.assertResultIds(_resultRecords, 0, 1);

  }

  /**
   */
  public void test_Most() throws Exception {
    // setup
    _queryBuilder.addAtMostFilter(_solrField, 2);

    // run
    execSearch();

    // verify
    SolrTestUtils.assertResultIds(_resultRecords, 0, 1, 2);

  }

  /**
   * @throws ProcessingException
   */
  private void execSearch() throws ProcessingException {
    _pipelet.process(_blackboard, new String[] { _record.getId() });
    final SolrResultAccessor results = new SolrResultAccessor(WORKFLOW, _record);
    _resultRecords = results.getResultRecords();
  }

}
