/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.solr;

import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.solr.search.SolrResultAccessor;

/** Tests conversion of search filter. */
public class SolrSearchPipelet_Filter_OnSets_Test extends SolrSearchPipeletTestBase {

  private AnySeq _resultRecords;

  @Override
  protected void setUp() throws Exception {
    super.setUp();

    _solrField = "attr_" + getName();
    addSolrDoc("1", _solrField, "1");
    addSolrDoc("2", _solrField, "2");
    addSolrDoc("3", _solrField, "3");
    addSolrDoc("4", _solrField, (Object[]) "4 5".split(" "));
    addSolrDoc("5", _solrField, (Object[]) "3 6".split(" "));

    _queryBuilder.setQuery("*:*");
    _queryBuilder.setResultAttributes(_solrField);
    indexAndCommit();

  }

  /**
   */
  public void test_OneOf() throws Exception {
    // setup
    _queryBuilder.addOneOfFilter(_solrField, 2, 3, 5);

    // run
    execSearch();

    // verify
    SolrTestUtils.assertResultIds(_resultRecords, 2, 3, 5, 4);

  }

  /**
   */
  public void test_NoneOf() throws Exception {
    // setup
    _queryBuilder.addNoneOfFilter(_solrField, 2, 3);

    // run
    execSearch();

    // verify
    SolrTestUtils.assertResultIds(_resultRecords, 1, 4);

  }

  /**
   */
  public void test_AllOf_Single() throws Exception {
    // setup
    _queryBuilder.addAllOfFilter(_solrField, 3);

    // run
    execSearch();

    // verify
    SolrTestUtils.assertResultIds(_resultRecords, 3, 5);

  }

  /**
   */
  public void test_AllOf_Multi() throws Exception {
    // setup
    _queryBuilder.addAllOfFilter(_solrField, 4, 5);

    // run
    execSearch();

    // verify
    SolrTestUtils.assertResultIds(_resultRecords, 4);

  }

  /**
   */
  private void execSearch() throws ProcessingException {
    _pipelet.process(_blackboard, new String[] { _record.getId() });
    final SolrResultAccessor results = new SolrResultAccessor(WORKFLOW, _record);
    _resultRecords = results.getResultRecords();
  }

}
