/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.solr;

import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.search.api.QueryConstants.SortOrder;
import org.eclipse.smila.solr.search.SolrResultAccessor;

/** test the sorting with an (embedded) solr. */
public class SolrSearchPipelet_Sortby_Test extends SolrSearchPipeletTestBase {

  /** SORT_FIELD2. */
  private static final String SORT_FIELD = "sort_l";

  private SolrResultAccessor _resultsAccessor;

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _solrField = getName() + "_t";
    // index docs
    addSolrDoc("1", _solrField, "go");
    addSolrDoc("2", _solrField, "go arg ");
    addSolrDoc("3", _solrField, "go no arg");
    _solrDocs.get(0).addField(SORT_FIELD, 1);
    _solrDocs.get(1).addField(SORT_FIELD, 2);
    _solrDocs.get(2).addField(SORT_FIELD, 2);
    indexAndCommit();

    _queryBuilder.setQuery(_solrField + ":go");

  }

  /**
   * tests that the case is properly setup and that when there is no sorting spec'ed the order is different from when it
   * is sorted.
   */
  public void test_ReferenceCheck() throws Exception {
    execSearch();
    SolrTestUtils.assertResultIdsInOrder(_resultsAccessor, 1, 2, 3);
  }

  /**
   * sorts on a single field.
   */
  public void test_Sort_Simple() throws Exception {
    _queryBuilder.addSortBy(SolrConstants.CORE_FIELD_ID, SortOrder.DESCENDING);
    execSearch();
    SolrTestUtils.assertResultIdsInOrder(_resultsAccessor, 3, 2, 1);
  }

  /**
   * test sorting on 2 fields. this is only complete with #test_Sort_MultiField_Counter
   */
  public void test_Sort_MultiField_Part1() throws Exception {
    _queryBuilder.addSortBy(SORT_FIELD, SortOrder.ASCENDING);
    _queryBuilder.addSortBy(SolrConstants.CORE_FIELD_ID, SortOrder.DESCENDING);
    execSearch();
    SolrTestUtils.assertResultIdsInOrder(_resultsAccessor, 1, 3, 2);
  }

  /**
   * counter test to cover the case completely.
   */
  public void test_Sort_MultiField_Part2() throws Exception {
    _queryBuilder.addSortBy(SORT_FIELD, SortOrder.ASCENDING);
    _queryBuilder.addSortBy(SolrConstants.CORE_FIELD_ID, SortOrder.ASCENDING);
    execSearch();
    SolrTestUtils.assertResultIdsInOrder(_resultsAccessor, 1, 2, 3);

  }

  /**
   */
  private void execSearch() throws ProcessingException {
    _pipelet.process(_blackboard, new String[] { _record.getId() });
    _resultsAccessor = new SolrResultAccessor(WORKFLOW, _record);
  }
}
