/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.solr.manual;

import java.util.Properties;

import junit.framework.TestCase;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.impl.BlackboardFactoryImpl;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactoryCreator;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.xml.XmlSerializationUtils;
import org.eclipse.smila.solr.SolrConstants;
import org.eclipse.smila.solr.SolrManager;
import org.eclipse.smila.solr.search.SolrQueryBuilder;
import org.eclipse.smila.solr.search.SolrResultAccessor;
import org.eclipse.smila.solr.search.SolrSearchPipelet;
import org.eclipse.smila.solr.util.FacetQueryConfigAdapter;
import org.eclipse.smila.solr.util.FacetQueryConfigAdapter.FacetType;
import org.eclipse.smila.solr.util.HighlightingQueryConfigAdapter;
import org.eclipse.smila.solr.util.SolrProperties;

/**

 * @author tmenzel
 */
public class SolrSearchPipelet_Remote_Test extends TestCase {

  /** WORKFLOW. */
  protected static final String WORKFLOW = "SearchPipeline";

  /**
   * most test cases need just one field for tests and this is it.
   */
  protected String _solrField;

  protected SolrQueryBuilder _queryBuilder;

  /** The logger. */
  protected final org.apache.commons.logging.Log _log = org.apache.commons.logging.LogFactory.getLog(this
    .getClass());

  protected Blackboard _blackboard;

  protected AnyMap _config;

  protected Record _record;

  private SolrSearchPipelet _pipelet;

  /**
   */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _config = DataFactoryCreator.createDefaultFactory().createAnyMap();
    _config.put(SolrConstants.CORE_NAME, SolrConstants.DEFAULT_CORE);

    _blackboard = new BlackboardFactoryImpl().createTransientBlackboard();

    // clear the index in advance before the (next) test

    // there query string isnt set here as it should be done by the sub class/test
    _queryBuilder = new SolrQueryBuilder(WORKFLOW);
    _queryBuilder.setId(getName());
    _queryBuilder.setIndexName(SolrConstants.DEFAULT_CORE);

    _record = _queryBuilder.getQuery();
    _blackboard.setRecord(_record);

    _solrField = "Content";
    _pipelet = new SolrSearchPipelet();

    final Properties props = new Properties();
    props.setProperty(SolrProperties.PROP_EMBEDDED, "false");
    props.setProperty(SolrProperties.PROP_SERVER_URL, "http://localhost:8983/solr");
    _pipelet.setSolrManager(new SolrManager(new SolrProperties(props)));

  }

  /**
   * ATM this doesnt test anything but is a test bed to generate queries that are dumped to th console, so i dont have to write them by hand
   */
  public void test_Search() throws Exception {

    _queryBuilder.setQuery(_solrField + ":berg");
    _queryBuilder.setResultAttributes("Content", "Content_deu_REX_LOCATION");

    // setup search
    final HighlightingQueryConfigAdapter hlConfig = new HighlightingQueryConfigAdapter();
    hlConfig.setHighlightingFields(_solrField);
    hlConfig.setHighlightingFragsize(300);
    hlConfig.setHighlightingFields("Content");
    _queryBuilder.addHighlightingConfiguration(hlConfig);

    final FacetQueryConfigAdapter config = new FacetQueryConfigAdapter(FacetType.GLOBAL);
    config.setFacetLimit(5);
    _queryBuilder.addFacetConfiguration(SolrConstants.GLOBAL, config);
    final String[] facetFields = "Content_deu_REX_LOCATION Content_deu_REX_PERSON Content_deu_REX_TITLE ".split(" ");
    for (final String facetField : facetFields) {
      _queryBuilder.addFacetConfiguration(facetField, new FacetQueryConfigAdapter(FacetType.FIELD));
    }

    _pipelet.process(_blackboard, new String[] { _record.getId() });
    _log.debug("result record: " + XmlSerializationUtils.serialize2string(_record));

    // verify
    final SolrResultAccessor results = new SolrResultAccessor(WORKFLOW, _record);
    final AnySeq resultRecords = results.getResultRecords();

  }

}
