/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskmanager;

/**
 * The completion status of a task.
 */
public enum TaskCompletionStatus {
  /** Successfully processed. */
  SUCCESSFUL,

  /** A fatal error occurred during processing. */
  FATAL_ERROR,

  /** A recoverable error occurred during processing. */
  RECOVERABLE_ERROR,

  /** This task is not yet processed, but not needed anymore. */
  OBSOLETE,

  /** This task cannot be processed, it must be redelivered. */
  POSTPONE;
}
