/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskmanager;

/**
 *  
 */
public class TaskCounter {
  /**
   * name of worker.
   */
  private final String _workerName;

  /**
   * number of tasks to do.
   */
  private final int _tasksTodo;

  /**
   * number of tasks currently in progress.
   */
  private final int _tasksInProgress;

  /**
   * Conversion Constructor.
   * 
   * @param workerName
   *          the name of the worker
   * @param tasksTodo
   *          the number of todo tasks
   * @param tasksInProgress
   *          the number of tasks in progress
   */
  public TaskCounter(final String workerName, final int tasksTodo, final int tasksInProgress) {
    super();
    _workerName = workerName;
    _tasksTodo = tasksTodo;
    _tasksInProgress = tasksInProgress;
  }

  /**
   * @return the name of the worker
   */
  public String getWorkerName() {
    return _workerName;
  }

  /**
   * Get the todo tasks.
   * 
   * @return the number of todo tasks
   */
  public int getTasksTodo() {
    return _tasksTodo;
  }

  /**
   * Get the task that are in progress.
   * 
   * @return the number of tasks in progress.
   */
  public int getTasksInProgress() {
    return _tasksInProgress;
  }

  @Override
  public String toString() {
    return "TaskCounter [_workerName=" + _workerName + ", _tasksTodo=" + _tasksTodo + ", _tasksInProgress="
      + _tasksInProgress + "]";
  }

}
