/**********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskworker.test;

import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.datamodel.ipc.IpcRecordReader;
import org.eclipse.smila.datamodel.ipc.IpcRecordWriter;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

/**
 * Test base for {@link TestInputs} and {@link TestOutputs}.
 */
public class InputOutputTestbase extends DeclarativeServiceTestCase {

  /** Helper for transforming streams and byte arrays to Any. */
  protected static final IpcAnyReader IPC_ANY_READER = new IpcAnyReader();

  /** Helper for transforming record to streams and byte arrays. */
  protected static final IpcRecordWriter IPC_RECORD_WRITER = new IpcRecordWriter();

  /** Helper for transforming streams and byte arrays to records. */
  protected static final IpcRecordReader IPC_RECORD_READER = new IpcRecordReader();

  /** The reference to the object store service. */
  protected ObjectStoreService _service;

  /**
   * {@inheritDoc}
   */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _service = getService(ObjectStoreService.class);
  }
}
