/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.taskworker.test.worker;

import java.io.InputStream;

import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.ipc.IpcRecordReader;
import org.eclipse.smila.datamodel.ipc.IpcRecordWriter;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.Inputs;
import org.eclipse.smila.taskworker.input.StreamInput;
import org.eclipse.smila.taskworker.output.Outputs;
import org.eclipse.smila.taskworker.output.StreamOutput;

/**
 * Test worker for reading from stream and writing something to it.
 */
public class StreamToStreamWorker implements Worker {

  public static final String NAME = "streamToStreamWorker";

  public static final String TEST_ATTRIBUTE = "streamToStream";

  public static final String TEST_STRING = "StreamToStreamWorker was here :-)";

  /** Helper for transforming record to streams and byte arrays. */
  protected static final IpcRecordWriter IPC_RECORD_WRITER = new IpcRecordWriter();

  /** Helper for transforming streams and byte arrays to records. */
  protected static final IpcRecordReader IPC_RECORD_READER = new IpcRecordReader();

  private static final String INPUT_SLOT_NAME = "inputRecords";

  private static final String OUTPUT_SLOT_NAME = "outputRecords";

  /**
   * Empty Constructor.
   */
  public StreamToStreamWorker() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void perform(TaskContext taskContext) {
    try {
      final Inputs inputs = taskContext.getInputs();
      final StreamInput streamInput = inputs.getAsStreamInput(INPUT_SLOT_NAME);
      final InputStream inputStream = streamInput.getStream();
      Record readRecord = IPC_RECORD_READER.readBinaryStream(inputStream);
      final Outputs outputs = taskContext.getOutputs();
      final StreamOutput streamOutput = outputs.getAsStreamOutput(OUTPUT_SLOT_NAME);
      while (readRecord != null) {
        try {
          readRecord.getMetadata().put(TEST_ATTRIBUTE, TEST_STRING);
          streamOutput.getStream().write(IPC_RECORD_WRITER.writeBinaryObject(readRecord));
          readRecord = IPC_RECORD_READER.readBinaryStream(inputStream);
        } catch (IllegalStateException ise) {
          readRecord = null;
        }
      }
    } catch (Exception e) {
      ;//do nothing, worker is just for testing
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return NAME;
  }
}
