/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.workermanager.test;

import junit.framework.TestCase;

import org.eclipse.smila.workermanager.ScaleUpControl;

/**
 * Tests for the ScaleUpControl class.
 */
public class TestScaleUpControl extends TestCase {

  private static final String SCALEUP_NEGATIVE_WORKER = "scaleupNegativeWorker";

  private static final String SCALEUP_ZERO_WORKER = "scaleupZeroWorker";

  private static final String SCALEUP_WORKER = "scaleupWorker";

  private static final String RUNALWAYS_WORKER = "runalwaysWorker";

  private static final Long SCALE_UP_LIMIT = new Long(5);

  /** tests that there are default limits if we use empty constructor. */
  public void testEmptyConstructor() throws Exception {
    final ScaleUpControl control = new ScaleUpControl();

    for (int i = 0; i < 1000; i++) {
      // default scaleUp = 1
      if (i == 0) {
        assertTrue(control.canGetTask(SCALEUP_WORKER, false));
        assertTrue(control.canGetTask(RUNALWAYS_WORKER, true));
      } else {
        assertFalse(control.canGetTask(SCALEUP_WORKER, false));
        assertFalse(control.canGetTask(RUNALWAYS_WORKER, true));
      }
      control.incTaskCounter(SCALEUP_WORKER);
      control.incTaskCounter(RUNALWAYS_WORKER);
    }
  }

  /** test with limits set for worker. */
  public void testScaleUpLimits() throws Exception {
    final ScaleUpControl control = createScaleUpControlWithLimits();
    assertTrue(control.canGetTask(RUNALWAYS_WORKER, true));
    control.incTaskCounter(RUNALWAYS_WORKER);
    assertFalse(control.canGetTask(RUNALWAYS_WORKER, true)); // RUNALWAYS worker is limited to 1

    for (int i = 0; i < SCALE_UP_LIMIT; i++) {
      assertTrue(control.canGetTask(SCALEUP_WORKER, false));
      assertFalse(control.canGetTask(SCALEUP_ZERO_WORKER, false));
      assertTrue(control.canGetTask(SCALEUP_NEGATIVE_WORKER, false));
      control.incTaskCounter(SCALEUP_WORKER);
      control.incTaskCounter(SCALEUP_NEGATIVE_WORKER);
    }
    assertFalse(control.canGetTask(RUNALWAYS_WORKER, true)); // RUNALWAYS worker is limited to 1
    control.decTaskCounter(RUNALWAYS_WORKER);
    assertTrue(control.canGetTask(RUNALWAYS_WORKER, true));

    assertTrue(control.canGetTask(SCALEUP_NEGATIVE_WORKER, false)); // negative scaleUp setting is unlimited
    assertFalse(control.canGetTask(SCALEUP_WORKER, false));
    control.decTaskCounter(SCALEUP_WORKER);
    assertTrue(control.canGetTask(SCALEUP_WORKER, false));
  }

  /** create ScaleUpControl with scale up limit settings for the workers. */
  private ScaleUpControl createScaleUpControlWithLimits() throws Exception {
    final ScaleUpControl control = new ScaleUpControl();
    control.setScaleUpLimit(RUNALWAYS_WORKER, SCALE_UP_LIMIT);
    control.setScaleUpLimit(SCALEUP_WORKER, SCALE_UP_LIMIT);
    control.setScaleUpLimit(SCALEUP_ZERO_WORKER, (long) 0);
    control.setScaleUpLimit(SCALEUP_NEGATIVE_WORKER, (long) -1);
    return control;
  }

}
