/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.zookeeper.test;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Suite combining all taskmanager integration tests.
 */
public final class AllTests {
  /**
   * The Constant BUNDLE_ID.
   */
  public static final String BUNDLE_ID = "org.eclipse.smila.zookeeper.test";

  /**
   * utility class, do not create instances.
   */
  private AllTests() {
  }

  /**
   * @return suite for all processing.pipelets tests
   */
  public static Test suite() {
    final TestSuite suite = new TestSuite("Test for org.eclipse.smila.zookeeper");
    // $JUnit-BEGIN$
    suite.addTestSuite(TestZooKeeperService.class);
    suite.addTestSuite(TestZkConcurrentMap.class);
    suite.addTestSuite(TestZkConnection.class);
    suite.addTestSuite(TestZkLock.class);
    // $JUnit-END$
    return suite;
  }
}
