/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.zookeeper.test;

import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs.Ids;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.eclipse.smila.test.DeclarativeServiceTestCase;
import org.eclipse.smila.zookeeper.ZooKeeperService;

public class OutOfMemoryTester extends DeclarativeServiceTestCase {

  /** ZooKeeper service. */
  private ZooKeeperService _zkService;

  private static final int MAX_LEVEL = 1000;

  private static final int NODES_PER_LEVEL = 10000;

  private static final int NODE_DATA_SIZE_BYTES = 10000;

  private static long _counter = 0;

  public void test() throws Exception {
    final ZooKeeper zk = new ZooKeeper("localhost:2181", 30000, null);
    createInfiniteNodes(zk, "/root", 0);
  }

  public void testCRUD() throws Exception {
    final ZooKeeper zk = new ZooKeeper("localhost:2181", 30000, null);
    testCRUD(zk, "/crud");
  }

  public void testWithService() throws Exception {
    _zkService = getService(ZooKeeperService.class);
    final ZooKeeper zk = _zkService.getClient();
    createInfiniteNodes(zk, "/root", 0);
  }

  private void createInfiniteNodes(final ZooKeeper zk, final String node, final int level) throws Exception {
    if (level > MAX_LEVEL) {
      return;
    }
    for (int i = 0; i < NODES_PER_LEVEL; i++) {
      final String child = node + i;
      zk.create(child, new byte[NODE_DATA_SIZE_BYTES], Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
      System.out.println(_counter++ + ", " + level);
      createInfiniteNodes(zk, child + "/" + i, level + 1);
    }
  }

  private void testCRUD(final ZooKeeper zk, final String node) throws Exception {
    long count = 0;
    while (true) {
      zk.create(node, new byte[NODE_DATA_SIZE_BYTES], Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
      Stat stat = zk.exists(node, false);
      assertNotNull(stat);
      byte[] readData = zk.getData(node, false, stat);
      assertEquals(NODE_DATA_SIZE_BYTES, readData.length);
      zk.setData(node, new byte[42], -1);
      readData = zk.getData(node, false, stat);
      assertEquals(42, readData.length);
      zk.delete(node, -1);
      stat = zk.exists(node, false);
      assertNull(stat);
      if (++count % 1000 == 0) {
        System.out.println("Done " + count + " CRUD cycles.");
      }
    }
  }
}
