package org.eclipse.smila.integration.worker;

import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.Inputs;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.Outputs;
import org.eclipse.smila.taskworker.output.RecordOutput;

public class HelloWorldWorker implements Worker {

  /** Test attribute to be filled. */
  public static final String TEST_ATTRIBUTE = "greeting";

  /** Test string to be filled in test attribute. */
  public static final String TEST_STRING = "HelloWorldWorker was here :-)";

  /** Name of the worker, used in worker description and workflows. */
  public static final String NAME = "HelloWorldWorker";

  /**
   * Name of input slot for reading records should match to workers.json and workflows.json.
   */
  private static final String INPUT_SLOT_NAME = "inputRecords";

  /**
   * Name of output slot for reading records should match to workers.json and workflows.json.
   */
  private static final String OUTPUT_SLOT_NAME = "outputRecords";

  /**
   * Empty Constructor.
   */
  public HelloWorldWorker() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void perform(final TaskContext taskContext) {
    try {
      // get input
      final Inputs inputs = taskContext.getInputs();
      final RecordInput recordInput = inputs.getAsRecordInput(INPUT_SLOT_NAME);
      // get output
      final Outputs outputs = taskContext.getOutputs();
      final RecordOutput recordOutput = outputs.getAsRecordOutput(OUTPUT_SLOT_NAME);
      Record record = recordInput.getRecord();
      while (record != null) {
        try {
          // write test string to test attribute
          record.getMetadata().put(TEST_ATTRIBUTE, TEST_STRING);
          recordOutput.writeRecord(record);
          record = recordInput.getRecord();
        } catch (final Exception e) {
          record = null;
        }
      }
    } catch (final Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return NAME;
  }
}
