/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.core.CoreContainer;
import org.eclipse.smila.solr.admin.SolrAdmin;
import org.eclipse.smila.solr.admin.SolrEmbeddedAdmin;
import org.eclipse.smila.solr.admin.SolrHttpAdmin;
import org.eclipse.smila.solr.server.SolrEmbeddedServers;
import org.eclipse.smila.solr.server.SolrHttpServers;
import org.eclipse.smila.solr.server.SolrServers;
import org.eclipse.smila.solr.util.SolrHelper;
import org.eclipse.smila.solr.util.SolrProperties;

public class SolrManager {
    private final SolrProperties _properties = new SolrProperties();
    private final Log _log = LogFactory.getLog(SolrManager.class);
    private CoreContainer _container;
    private SolrServers _servers;
    private SolrAdmin _admin;
    private SolrHelper _helper;

    public SolrManager() {
        this(new SolrProperties());
    }

    public SolrManager(SolrProperties properties) {
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"Start SolrManager instance...");
            }
            this._helper = new SolrHelper(properties);
            if (this._properties.isEmbedded().booleanValue()) {
                this.loadCoreContainer();
                this._servers = new SolrEmbeddedServers(this._container);
                this._admin = new SolrEmbeddedAdmin(this._helper, this._servers, this._container);
            } else {
                this._servers = new SolrHttpServers(this._properties);
                this._admin = new SolrHttpAdmin(this._helper, this._servers);
            }
        }
        catch (Exception exception) {
            this._log.error((Object)"Error while initialize SolrManager", (Throwable)exception);
        }
    }

    private void loadCoreContainer() throws Exception {
        File solr = this._helper.getSolrXML();
        this._container = new CoreContainer();
        this._container.load(this._helper.getSolrHome().getAbsolutePath(), solr);
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)"Solr CoreContainer for EmbeddedSolrServer loaded successfully.");
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Available solr cores: " + StringUtils.join((Collection)this._container.getCoreNames(), (String)File.pathSeparator)));
        }
    }

    public SolrProperties getSolrProperties() {
        return this._properties;
    }

    public SolrAdmin getSolrAdmin() {
        return this._admin;
    }

    public SolrHelper getSolrHelper() {
        return this._helper;
    }

    public CoreContainer getCoreContainer() {
        return this._container;
    }

    public Collection<String> getCoreNames() {
        try {
            return this._admin.getCoreNames();
        }
        catch (Exception ex) {
            this._log.error((Object)"Error getting core names from Solr", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public SolrServer getSolrServer(String coreName) throws SolrServerException, IOException {
        return this._servers.getSolrServer(coreName);
    }
}

