/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.index;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.xml.XmlSerializationUtils;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.MissingParameterException;
import org.eclipse.smila.solr.Activator;
import org.eclipse.smila.solr.SolrConstants;
import org.eclipse.smila.solr.SolrManager;
import org.eclipse.smila.solr.util.SolrQueryUtils;

public class SolrIndexPipelet
implements Pipelet {
    private static final String CONF_ERROR = "Invalid Pipelet configuration -> ";
    private static final String CONF_ERROR_PARAMETER_MISSING = "Invalid Pipelet configuration -> Parameter missing: ";
    private final Log _log = LogFactory.getLog(SolrIndexPipelet.class);
    private AnyMap _configuration;
    private AnySeq _coreFieldsSeq;
    private SolrConstants.ExecutionMode _executionMode;
    private SolrServer _defaultTargetCore;
    private String _defaultCoreName;

    public void configure(AnyMap configuration) throws ProcessingException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Configure SolrIndexPipelet");
        }
        this._configuration = configuration;
        try {
            if (StringUtils.isBlank((String)configuration.getStringValue("ExecutionMode"))) {
                throw new MissingParameterException("Invalid Pipelet configuration -> Parameter missing: ExecutionMode");
            }
            this._executionMode = SolrConstants.ExecutionMode.valueOf(this._configuration.getStringValue("ExecutionMode"));
            switch (this._executionMode) {
                case DELETE: {
                    break;
                }
                case ADD: 
                case UPDATE: {
                    this._coreFieldsSeq = this._configuration.getSeq("CoreFields");
                    for (Any coreFieldMap : this._coreFieldsSeq) {
                        if (coreFieldMap.isMap()) continue;
                        throw new ProcessingException("all items must be of type AnyMap in pipelet config: CoreFields");
                    }
                    break;
                }
                default: {
                    throw new NotImplementedException("_executionMode: " + (Object)((Object)this._executionMode));
                }
            }
            this._defaultCoreName = StringUtils.trimToNull((String)this._configuration.getStringValue("CoreName"));
            if (StringUtils.isBlank((String)this._defaultCoreName)) {
                this._log.warn((Object)"there is no default core configured in the pipelet config! Target core must be set now on each record dynamically via: _coreName");
            }
        }
        catch (Exception exception) {
            throw new ProcessingException("Error while configure SolrIndexPipelet", (Throwable)exception);
        }
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            if (this._defaultCoreName != null) {
                try {
                    this._defaultTargetCore = this.getSolrManager().getSolrServer(this._defaultCoreName);
                }
                catch (Exception e) {
                    this._log.warn((Object)String.format("default core not reachable: %s. Records must have a dynamic core specified or their processing will fail. Exception: %s", this._defaultCoreName, e.getMessage()));
                }
            }
            switch (this._executionMode) {
                case ADD: {
                    this.addRecords(blackboard, recordIds);
                    break;
                }
                case DELETE: {
                    this.deleteRecords(blackboard, recordIds);
                    break;
                }
                default: {
                    throw new NotImplementedException("executionMode: " + (Object)((Object)this._executionMode));
                }
            }
        }
        return recordIds;
    }

    private void addRecords(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        HashMap<SolrServer, Collection<SolrInputDocument>> coreToDocsMap = new HashMap<SolrServer, Collection<SolrInputDocument>>();
        int recordCount = recordIds.length;
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.traceRecord(blackboard, id);
            try {
                AnyMap metadata = blackboard.getMetadata(id);
                Collection<SolrInputDocument> solrDocs = this.getInputDocumentsForCore(coreToDocsMap, metadata, recordCount);
                SolrInputDocument doc = this.createInputDocument(blackboard, id, metadata);
                solrDocs.add(doc);
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)("record added to memory document collection: " + id));
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("solr document: " + doc.toString()));
                    }
                }
            }
            catch (Exception e) {
                String msg = "Error while adding record with id: " + id;
                throw new ProcessingException(msg, (Throwable)e);
            }
            ++n2;
        }
        try {
            for (Map.Entry entry : coreToDocsMap.entrySet()) {
                SolrServer server = (SolrServer)entry.getKey();
                Collection docs = (Collection)entry.getValue();
                this.addDocumentsToServer(server, docs);
            }
        }
        catch (Exception e) {
            throw new ProcessingException("Error while adding document collection to solr server.", (Throwable)e);
        }
    }

    private Collection<SolrInputDocument> getInputDocumentsForCore(Map<SolrServer, Collection<SolrInputDocument>> coreToDocsMap, AnyMap metadata, int recordCount) throws SolrServerException, IOException, ProcessingException {
        SolrServer targetCore = this.getTargetCore(metadata);
        Collection<SolrInputDocument> solrDocs = coreToDocsMap.get(targetCore);
        if (solrDocs == null) {
            solrDocs = new ArrayList<SolrInputDocument>(recordCount);
            coreToDocsMap.put(targetCore, solrDocs);
        }
        return solrDocs;
    }

    private SolrServer getTargetCore(AnyMap metadata) throws SolrServerException, IOException, ProcessingException {
        if (metadata.containsKey((Object)"_coreName")) {
            return this.getSolrManager().getSolrServer(metadata.getStringValue("_coreName"));
        }
        if (this._defaultTargetCore == null) {
            throw new ProcessingException("no dynamic core in record given while default core is null. check if the pipelet defines a valid default core or that the record carries the dynamicCore attribute");
        }
        return this._defaultTargetCore;
    }

    private SolrInputDocument createInputDocument(Blackboard blackboard, String id, AnyMap metadata) throws ProcessingException, BlackboardAccessException, UnsupportedEncodingException {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField("_recordid", (Object)id);
        Double boostFactor = metadata.getDoubleValue("_docBoost");
        if (boostFactor != null) {
            doc.setDocumentBoost(boostFactor.floatValue());
        }
        for (Any coreFieldMap : this._coreFieldsSeq) {
            AnyMap fieldMap = coreFieldMap.asMap();
            String fieldName = this.getFieldName(fieldMap);
            String recSourceName = this.getRecordSourceName(fieldMap, fieldName);
            SolrConstants.AttributeOrAttachment recSourceType = this.getRecordSourceType(fieldMap, fieldName);
            switch (recSourceType) {
                case ATTRIBUTE: {
                    this.createFieldFromAttribute(doc, fieldName, metadata, recSourceName);
                    break;
                }
                case ATTACHMENT: {
                    this.createFieldFromAttachment(doc, fieldName, blackboard, id, recSourceName);
                    break;
                }
                default: {
                    throw new NotImplementedException("recSourceType: " + (Object)((Object)recSourceType));
                }
            }
        }
        return doc;
    }

    private String getFieldName(AnyMap fieldMap) throws MissingParameterException {
        String fieldName = fieldMap.getStringValue("FieldName");
        if (StringUtils.isBlank((String)fieldName)) {
            throw new MissingParameterException("Invalid Pipelet configuration -> Parameter missing: FieldName");
        }
        return fieldName;
    }

    private String getRecordSourceName(AnyMap fieldMap, String fieldName) {
        String recSourceName = fieldMap.getStringValue("RecSourceName");
        if (StringUtils.isBlank((String)recSourceName)) {
            recSourceName = fieldName;
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)String.format("core field mapping %s: no %s config'ed. Defaulting to field name", fieldName, "RecSourceName"));
            }
        }
        return recSourceName;
    }

    private SolrConstants.AttributeOrAttachment getRecordSourceType(AnyMap fieldMap, String fieldName) {
        SolrConstants.AttributeOrAttachment recSourceType;
        String recSourceTypeString = fieldMap.getStringValue("RecSourceType");
        if (StringUtils.isBlank((String)recSourceTypeString)) {
            recSourceType = SolrConstants.AttributeOrAttachment.ATTRIBUTE;
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)String.format("core field mapping %s: no %s config'ed. Defaulting to %s", new Object[]{fieldName, "RecSourceType", recSourceType}));
            }
        } else {
            recSourceType = SolrConstants.AttributeOrAttachment.valueOf(recSourceTypeString.toUpperCase());
        }
        return recSourceType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createFieldFromAttribute(SolrInputDocument doc, String fieldName, AnyMap metadata, String recordAttribute) throws ProcessingException {
        Any any = (Any)metadata.get((Object)recordAttribute);
        if (any != null) {
            if (any.isValue()) {
                doc.addField(fieldName, any.asValue().getObject());
                return;
            } else {
                if (!any.isSeq()) throw new ProcessingException("value type for indexing in solr not supported. Must be one of Value, Seq but is: " + any.getValueType());
                AnySeq asSeq = any.asSeq();
                for (Any seqValues : asSeq) {
                    doc.addField(fieldName, seqValues.asValue().getObject());
                }
            }
            return;
        } else {
            if (!this._log.isTraceEnabled()) return;
            this._log.trace((Object)("Record doesn't contain an attribute named: " + recordAttribute));
        }
    }

    private void createFieldFromAttachment(SolrInputDocument doc, String fieldName, Blackboard blackboard, String id, String attachmentName) throws BlackboardAccessException, UnsupportedEncodingException {
        byte[] value = blackboard.getAttachmentAsBytes(id, attachmentName);
        if (value != null) {
            String string = new String(value, "UTF-8");
            doc.addField(fieldName, (Object)string);
        } else if (this._log.isTraceEnabled() && !blackboard.hasAttachment(id, attachmentName)) {
            this._log.trace((Object)("Record doesn't have an attachment named: " + attachmentName));
        }
    }

    private void addDocumentsToServer(SolrServer server, Collection<SolrInputDocument> docs) throws SolrServerException, IOException, ProcessingException {
        UpdateResponse solrResponse = server.add(docs);
        if (SolrQueryUtils.responseStatusIsError((SolrResponseBase)solrResponse)) {
            throw new ProcessingException("Error reported by solr reponse with status: " + solrResponse.getStatus());
        }
        if (this._log.isDebugEnabled()) {
            this._log.info((Object)MessageFormat.format("document collection was added to solr in {1} ms, doc count = {0} ", docs.size(), solrResponse.getElapsedTime()));
        }
    }

    private void traceRecord(Blackboard blackboard, String id) {
        if (this._log.isTraceEnabled()) {
            try {
                Record record = blackboard.getRecord(id);
                String serialize2string = XmlSerializationUtils.serialize2string((Record)record).replace('\n', ' ');
                this._log.trace((Object)("processing record: " + serialize2string));
            }
            catch (BlackboardAccessException e) {
                this._log.trace((Object)"error on serializing the record for logging: ", (Throwable)e);
            }
        }
    }

    private void deleteRecords(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                AnyMap metadata = blackboard.getMetadata(id);
                String indexName = StringUtils.defaultIfEmpty((String)metadata.getStringValue("_coreName"), (String)this._defaultCoreName);
                SolrServer server = this.getSolrManager().getSolrServer(indexName);
                UpdateResponse deleteResponse = server.deleteById(id);
                if (SolrQueryUtils.responseStatusIsError((SolrResponseBase)deleteResponse)) {
                    throw new ProcessingException("Error reported by solr reponse while delete record with id: " + id);
                }
                if (this._log.isDebugEnabled()) {
                    String msg = MessageFormat.format("Record deleted: Id: {0} Index: {1} time: {2}ms.", id, deleteResponse.getRequestUrl(), deleteResponse.getElapsedTime());
                    this._log.debug((Object)msg);
                }
            }
            catch (Exception e) {
                throw new ProcessingException("Error while delete record with id: " + id, (Throwable)e);
            }
            ++n2;
        }
    }

    public SolrManager getSolrManager() {
        return Activator.getInstance().getSolrManager();
    }
}

