/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.search;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.solr.search.SolrQueryParameterAccessor;
import org.eclipse.smila.solr.util.SolrQueryUtils;

public class SolrQueryConverter {
    protected final Log _log = LogFactory.getLog(this.getClass());
    private final SolrQueryParameterAccessor _accessor;
    private final SolrQuery _solrQuery = new SolrQuery();

    public SolrQueryConverter(SolrQueryParameterAccessor accessor) {
        this._accessor = accessor;
    }

    public SolrQuery toSolrQuery(List<String> schemaAttributes) {
        String qt = this._accessor.getRequestHandler();
        this._solrQuery.setQueryType(qt);
        this.doQuery(schemaAttributes);
        this.doSortOrder();
        this.doTermsSettings();
        this.doFilters();
        this.doFacetSettings();
        if (this._solrQuery.getQuery() != null || this._solrQuery.getFields() != null) {
            this.doQuerySettings();
            this.doHighlightingSettings();
            this.doShardsSettings();
            this.doSpellCheckSettings();
            this.doMoreLikeThis();
        }
        AnyMap map = this._accessor.getSolrQueryParams().getMap("nativeParameters");
        this.addAsSolrParameters(map, null);
        return this._solrQuery;
    }

    private void doQuery(List<String> schemaAttributes) {
        String q = this._accessor.getQuery();
        if (StringUtils.isEmpty((String)q) && schemaAttributes != null && !schemaAttributes.isEmpty()) {
            StringBuilder fieldQuery = new StringBuilder();
            for (String field : schemaAttributes) {
                List fieldQueryValues = this._accessor.getQueryAttributeValues(field);
                if (fieldQueryValues == null) continue;
                SolrQueryUtils.appendFieldQueryPart(fieldQuery, field, fieldQueryValues);
            }
            q = fieldQuery.toString().trim();
        }
        if (!StringUtils.isEmpty((String)q)) {
            this._solrQuery.setQuery(q);
        }
    }

    private void doQuerySettings() {
        int start = this._accessor.getOffset();
        this._solrQuery.setStart(Integer.valueOf(start));
        int rows = this._accessor.getMaxCount();
        this._solrQuery.setRows(Integer.valueOf(rows));
        String[] fl = this._accessor.getResultAttributes().toArray(new String[this._accessor.getResultAttributes().size()]);
        this._solrQuery.setFields(fl);
        this._solrQuery.addField("score");
        this._solrQuery.addField("_recordid");
    }

    private void doSortOrder() {
        List annotations = this._accessor.getSubParameters("sortby");
        if (annotations != null) {
            for (AnyMap annotation : annotations) {
                String attributeName = annotation.getStringValue("attribute");
                String orderModeValue = annotation.getStringValue("order");
                if (StringUtils.startsWith((String)orderModeValue, (String)"asc")) {
                    this._solrQuery.addSortField(attributeName, SolrQuery.ORDER.asc);
                    continue;
                }
                this._solrQuery.addSortField(attributeName, SolrQuery.ORDER.desc);
            }
        }
    }

    private void doFilters() {
        this.addFilterSolrSyntax();
        if (this._accessor.hasFilters()) {
            this.addFilterSmilaSyntax();
        }
    }

    private void addFilterSmilaSyntax() {
        List filters = this._accessor.getSubParameters("filter");
        StringBuilder fq = new StringBuilder(4095);
        int i = 0;
        while (i < filters.size()) {
            AnyMap filter = (AnyMap)filters.get(i);
            String attribute = filter.getStringValue("attribute");
            if (attribute == null) {
                this._log.warn((Object)MessageFormat.format("no attribute defined for given filter @ index: {0}. It is ignored.", i));
            } else {
                this.addFilterSmilaSyntax(fq, attribute, filter, i);
            }
            ++i;
        }
    }

    private void addFilterSmilaSyntax(StringBuilder fq, String attribute, AnyMap filter, int i) {
        for (Map.Entry condition : filter.entrySet()) {
            String value;
            fq.setLength(0);
            String filterType = (String)condition.getKey();
            if ("attribute".equals(filterType)) continue;
            if ("oneOf".equals(filterType)) {
                this.appendFilterSetExpression(fq, attribute, ((Any)condition.getValue()).asSeq(), "");
            } else if ("allOf".equals(filterType)) {
                this.appendFilterSetExpression(fq, attribute, ((Any)condition.getValue()).asSeq(), "+");
            } else if ("noneOf".equals(filterType)) {
                this.appendFilterSetExpression(fq, attribute, ((Any)condition.getValue()).asSeq(), "-");
            } else if ("atLeast".equals(filterType)) {
                value = ((Any)condition.getValue()).asValue().asString();
                this.addFilterRangeExpression(attribute, fq, value, "*", false);
            } else if ("greaterThan".equals(filterType)) {
                value = ((Any)condition.getValue()).asValue().asString();
                this.addFilterRangeExpression(attribute, fq, value, "*", true);
            } else if ("atMost".equals(filterType)) {
                value = ((Any)condition.getValue()).asValue().asString();
                this.addFilterRangeExpression(attribute, fq, "*", value, false);
            } else if ("lessThan".equals(filterType)) {
                value = ((Any)condition.getValue()).asValue().asString();
                this.addFilterRangeExpression(attribute, fq, "*", value, true);
            } else {
                this._log.warn((Object)String.format("unknown (filter) element in filters encountered on attribute %s: %s[%s]. It is ignored.", attribute, filterType, i));
            }
            if (fq.length() == 0) {
                this._log.warn((Object)String.format("Filter on attribute %s: %s[%d] has no values and is ignored!", attribute, filterType, i));
                continue;
            }
            String fqString = fq.toString();
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)String.format("Filter converted from Smila Syntax on attribute %s: %s[%d]: %s", attribute, filterType, i, fqString));
            }
            this._solrQuery.addFilterQuery(new String[]{fqString});
        }
    }

    private void addFilterRangeExpression(String attribute, StringBuilder fq, String lower, String upper, boolean exclusive) {
        if (StringUtils.isBlank((String)lower)) {
            throw new IllegalArgumentException("lower bound must not be blank");
        }
        if (StringUtils.isBlank((String)upper)) {
            throw new IllegalArgumentException("upper bound must not be blank");
        }
        lower = this.appendFilterRangeExpressionBoundExclusionIfNotStar(lower, exclusive, fq, attribute);
        upper = this.appendFilterRangeExpressionBoundExclusionIfNotStar(upper, exclusive, fq, attribute);
        fq.append(" +(");
        fq.append(attribute);
        fq.append(":[");
        fq.append(lower);
        fq.append(" TO ");
        fq.append(upper);
        fq.append("])");
    }

    private String appendFilterRangeExpressionBoundExclusionIfNotStar(String value, boolean exclusive, StringBuilder fq, String attribute) {
        if (!"*".equals(value)) {
            value = SolrQueryUtils.escapeQuery(value, "+-&|!(){}[]^~*?:\\\" ");
            if (exclusive) {
                fq.append(" -(");
                fq.append(attribute);
                fq.append(":");
                fq.append(value);
                fq.append(")");
            }
        }
        return value;
    }

    private void appendFilterSetExpression(StringBuilder fq, String attribute, AnySeq values, String operator) {
        List filterValues;
        try {
            filterValues = values.asStrings();
        }
        catch (InvalidValueTypeException e) {
            throw new InvalidValueTypeException("Filter Syntax Error: Filter must be of Type Seq and contain only Val elements.", (Exception)((Object)e));
        }
        for (String filterValue : filterValues) {
            fq.append(operator);
            fq.append("(");
            fq.append(attribute);
            fq.append(":");
            fq.append(SolrQueryUtils.escapeQuery(filterValue, "+-&|!(){}[]^~*?:\\\" "));
            fq.append(")");
        }
    }

    private void addFilterSolrSyntax() {
        AnySeq seq = this._accessor.getFilterQuery();
        if (seq != null) {
            String[] fq = seq.asStrings().toArray(new String[seq.size()]);
            this._solrQuery.setFilterQueries(fq);
        }
    }

    private void doFacetSettings() {
        List facetByConfig = this._accessor.getFacetByConfig();
        if (!facetByConfig.isEmpty()) {
            StringBuilder fq = new StringBuilder(4095);
            this._solrQuery.add("facet", new String[]{"true"});
            int facetByIndex = 0;
            for (AnyMap facetConfig : facetByConfig) {
                AnyMap sortby;
                ++facetByIndex;
                String attribute = facetConfig.getStringValue("attribute");
                if (attribute == null) {
                    this._log.warn((Object)MessageFormat.format("no attribute defined for facet @ index: {0}. It is ignored.", facetByIndex));
                    continue;
                }
                String fieldName = attribute;
                String facetType = StringUtils.defaultString((String)facetConfig.getStringValue("type"), (String)"facet.field");
                this._solrQuery.add(facetType, new String[]{fieldName});
                String maxCount = facetConfig.getStringValue("maxcount");
                if (maxCount != null) {
                    this.addFieldParameter(fieldName, "facet.limit", maxCount);
                }
                if ((sortby = facetConfig.getMap("sortby")) != null) {
                    String criterion = sortby.getStringValue("criterion");
                    this.addFieldParameter(fieldName, "facet.sort", criterion);
                    if (this._log.isWarnEnabled() && sortby.containsKey((Object)"order")) {
                        this._log.warn((Object)String.format("facet config for field %s contains value for unsupported sort order. It is ignored", fieldName));
                    }
                }
                AnyMap map = facetConfig.getMap("nativeParameters");
                this.addAsSolrParameters(map, fieldName);
                AnySeq filters = facetConfig.getSeq("oneOf");
                if (filters != null) {
                    this.appendFilterSetExpression(fq, attribute, filters, "");
                }
                if (fq.length() <= 0) continue;
                this._solrQuery.addFilterQuery(new String[]{fq.toString()});
                fq.setLength(0);
            }
        }
    }

    private void doTermsSettings() {
        AnyMap terms = this._accessor.getTerms();
        if (terms != null) {
            this._solrQuery.setParam("qt", new String[]{"/terms"});
            this.addAsSolrParameters(terms, null);
        }
    }

    private void doHighlightingSettings() {
        AnySeq seq = this._accessor.getHighlighting();
        if (seq != null) {
            for (Any map : seq) {
                if (!map.isMap()) continue;
                AnyMap highlighting = map.asMap();
                String attribute = highlighting.getStringValue("attribute");
                if (attribute.equals("global.solr.params")) {
                    this.addAsSolrParameters(highlighting, null);
                    continue;
                }
                this.addAsSolrParameters(highlighting, attribute);
            }
        }
    }

    private void addAsSolrParameters(AnyMap map, String field) {
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("attribute")) continue;
            String value = ((Any)entry.getValue()).asValue().asString();
            if (StringUtils.isBlank((String)field)) {
                this._solrQuery.add(key, new String[]{value});
                continue;
            }
            this.addFieldParameter(field, key, value);
        }
    }

    private void addFieldParameter(String field, String paramName, String value) {
        String parmName = "f." + field + "." + paramName;
        this._solrQuery.add(parmName, new String[]{value});
    }

    private void doShardsSettings() {
        AnySeq seq = this._accessor.getShards();
        if (seq != null) {
            String shards = StringUtils.join((Collection)seq.asStrings(), (String)",");
            this._solrQuery.setParam("shards", new String[]{shards});
        }
    }

    private void doSpellCheckSettings() {
        AnyMap spellcheck = this._accessor.getSpellcheck();
        if (spellcheck != null) {
            this.addAsSolrParameters(spellcheck, null);
        }
    }

    private void doMoreLikeThis() {
        AnyMap moreLikeThis = this._accessor.getMoreLikeThis();
        if (moreLikeThis != null) {
            this.addAsSolrParameters(moreLikeThis, null);
        }
    }
}

