/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.search;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.search.api.helper.ResultBuilder;

public class SolrResultBuilder
extends ResultBuilder {
    private static final String DEFAULT_WORKFLOW = "SolrSearchDefaultWorkflow";
    private final QueryResponse _response;
    final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public SolrResultBuilder(Record record, QueryResponse response) {
        super(DEFAULT_WORKFLOW, record);
        this._response = response;
    }

    public SolrResultBuilder(String workflowName, Record record, QueryResponse response) {
        super(workflowName, record);
        this._response = response;
    }

    public Record processResponse() {
        this.setRuntime(new Long(this._response.getQTime()));
        this.processQueryResponse();
        this.processFacetResponse();
        this.processTermsResponse();
        this.processSpellcheckResponse();
        this.processMoreLikeThis();
        return this.getResult();
    }

    private void processMoreLikeThis() {
        Object mltResults = this._response.getResponse().get("moreLikeThis");
    }

    private void processQueryResponse() {
        SolrDocumentList results = this._response.getResults();
        if (results == null) {
            return;
        }
        SimpleOrderedMap<SolrDocumentList> moreLikeThisLists = this.getMoreLikeThisLists();
        this.setCount(results.getNumFound());
        this.setMaxScore(results.getMaxScore());
        int index = 0;
        for (SolrDocument document : results) {
            AnyMap item = this.convertSolrDocToSmilaResultItemStub(document);
            this.getResultRecords().add((Object)item);
            this.addResultFieldsToItem(item, document);
            this.processHighlightingResponse(item);
            if (moreLikeThisLists != null) {
                SolrDocumentList relatedDocs = (SolrDocumentList)moreLikeThisLists.getVal(index);
                this.addMoreLikeThisToItem(item, relatedDocs);
            }
            ++index;
        }
    }

    private SimpleOrderedMap<SolrDocumentList> getMoreLikeThisLists() {
        Object mltObject = this._response.getResponse().get("moreLikeThis");
        if (mltObject != null) {
            if (mltObject instanceof SimpleOrderedMap) {
                return (SimpleOrderedMap)mltObject;
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)String.format("object %s is not a SimpleOrderedMap but of type %s", "moreLikeThis", mltObject.getClass()));
            }
        } else if (this._log.isDebugEnabled()) {
            this._log.debug((Object)String.format("object %s does not exist in response", "moreLikeThis"));
        }
        return null;
    }

    private AnyMap convertSolrDocToSmilaResultItemStub(SolrDocument document) {
        Double score;
        String id;
        block2: {
            id = (String)document.getFieldValue("_recordid");
            score = -1.0;
            Object scoreObj = document.getFieldValue("score");
            try {
                Number scoreNumber = (Number)scoreObj;
                score = scoreNumber.doubleValue();
            }
            catch (Exception e) {
                if (!this._log.isWarnEnabled()) break block2;
                String msg = e instanceof NullPointerException ? "No score value in the solr result for id: " + id : (e instanceof ClassCastException ? MessageFormat.format("The score value returned from solr is not a Number for id: {0} -> score as string: {1}", id, scoreObj) : "Cannot get score for id: " + id);
                this._log.warn((Object)(String.valueOf(msg) + ". Setting score to -1. Check your config to fix this."));
            }
        }
        AnyMap resultItem = this.getResultRecords().getFactory().createAnyMap();
        resultItem.put("_recordid", id);
        resultItem.put("_weight", (Number)score);
        return resultItem;
    }

    private void addMoreLikeThisToItem(AnyMap item, SolrDocumentList relatedDocs) {
        AnyMap map = item.getMap("_mlt.meta", true);
        map.put("start", (Number)relatedDocs.getStart());
        map.put("count", (Number)relatedDocs.getNumFound());
        map.put("max_score", (Number)relatedDocs.getMaxScore());
        AnySeq mltSeq = item.getSeq("_mlt", true);
        for (SolrDocument solrMltDoc : relatedDocs) {
            AnyMap mltSmilaItem = this.convertSolrDocToSmilaResultItemStub(solrMltDoc);
            this.addResultFieldsToItem(mltSmilaItem, solrMltDoc);
            mltSeq.add((Object)mltSmilaItem);
        }
    }

    private void addResultFieldsToItem(AnyMap item, SolrDocument document) {
        for (Map.Entry entry : document.entrySet()) {
            try {
                Object value;
                String key = (String)entry.getKey();
                if (key.equals("_recordid") || key.equals("score") || (value = entry.getValue()) == null) continue;
                if (value instanceof Collection) {
                    this.addMultiKeyValuePairToItem(key, value, item);
                    continue;
                }
                this.addSingleKeyValuePairToItem(key, value, item);
            }
            catch (Exception exception) {
                if (!this._log.isWarnEnabled()) continue;
                this._log.warn((Object)("Error adding solr result to record item for field name: " + (String)entry.getKey() + ". this field has been skipped."), (Throwable)exception);
            }
        }
    }

    private void addSingleKeyValuePairToItem(String key, Object value, AnyMap item) {
        DataFactory factory = item.getFactory();
        Value autoConvertValue = factory.autoConvertValue(value);
        item.put(key, (Any)autoConvertValue);
    }

    private void addMultiKeyValuePairToItem(String key, Object value, AnyMap item) {
        DataFactory factory = item.getFactory();
        Collection multiValues = (Collection)value;
        AnySeq seq = factory.createAnySeq();
        item.put(key, (Any)seq);
        for (Object multiValue : multiValues) {
            Value autoConvertValue = factory.autoConvertValue(multiValue);
            seq.add((Object)autoConvertValue);
        }
    }

    private void processHighlightingResponse(AnyMap item) {
        Map highlighting = this._response.getHighlighting();
        if (highlighting == null) {
            return;
        }
        String id = item.getStringValue("_recordid");
        Map map = (Map)highlighting.get(id);
        for (String key : map.keySet()) {
            List list = (List)map.get(key);
            if (list.size() > 1) {
                this.addMultiKeyValuePairToItem(key, list, item);
                continue;
            }
            this.addSingleKeyValuePairToItem(key, list.get(0), item);
        }
    }

    private void processFacetResponse() {
        Map facetQuery;
        if (this._response.getFacetFields() != null) {
            for (FacetField facet : this._response.getFacetFields()) {
                this.addFacetFieldToRecord(facet);
            }
        }
        if (this._response.getFacetDates() != null) {
            for (FacetField facet : this._response.getFacetDates()) {
                this.addFacetFieldToRecord(facet);
            }
        }
        if (this._response.getFacetQuery() != null && (facetQuery = this._response.getFacetQuery()).size() > 0) {
            Set keySet = facetQuery.keySet();
            String firstKey = keySet.toArray(new String[keySet.size()])[0];
            String name = StringUtils.substringBefore((String)firstKey, (String)":");
            AnySeq facet = this.addFacet(name);
            for (String key : keySet) {
                this.addFacetValue(facet, key, ((Integer)facetQuery.get(key)).longValue());
            }
        }
    }

    private void addFacetFieldToRecord(FacetField facet) {
        List values = facet.getValues();
        if (values == null || values.size() < 1) {
            return;
        }
        AnySeq facetSeq = this.addFacet(facet.getName());
        facetSeq.getFactory();
        for (FacetField.Count count : values) {
            this.addFacetValue(facetSeq, count.getName(), count.getCount());
        }
        facetSeq.add((Number)facet.getValueCount());
    }

    private void processTermsResponse() {
        NamedList terms = (NamedList)this._response.getResponse().get("terms");
        if (terms == null) {
            return;
        }
        AnyMap map = this.getTermsMap(true);
        DataFactory factory = map.getFactory();
        int i = 0;
        while (i < terms.size()) {
            NamedList field = (NamedList)terms.getVal(i);
            int z = 0;
            while (z < field.size()) {
                String name = field.getName(z);
                Object value = field.getVal(z);
                Value autoConvertValue = factory.autoConvertValue(value);
                map.put(name, (Any)autoConvertValue);
                ++z;
            }
            ++i;
        }
    }

    private void processSpellcheckResponse() {
        SpellCheckResponse spellcheck = this._response.getSpellCheckResponse();
        if (spellcheck == null) {
            return;
        }
        Map suggestions = spellcheck.getSuggestionMap();
        if (suggestions != null && suggestions.size() > 0) {
            AnyMap map = this.getSpellcheckMap(true);
            for (Map.Entry entry : suggestions.entrySet()) {
                SpellCheckResponse.Suggestion suggestion = (SpellCheckResponse.Suggestion)entry.getValue();
                if (suggestion == null) continue;
                AnyMap results = map.getMap((String)entry.getKey(), true);
                List alternatives = suggestion.getAlternatives();
                List altervativeFrequencies = suggestion.getAlternativeFrequencies();
                int i = 0;
                while (i < suggestion.getNumFound()) {
                    if (altervativeFrequencies != null) {
                        results.put((String)alternatives.get(i), (Number)altervativeFrequencies.get(i));
                    } else {
                        results.put((String)alternatives.get(i), (Number)-1);
                    }
                    ++i;
                }
            }
            String collation = spellcheck.getCollatedResult();
            if (collation != null) {
                map.put("collation", collation);
            }
        }
    }

    AnyMap getSolrResultMap(Boolean create) {
        return this.getResult().getMetadata().getMap("_solr.result", create.booleanValue());
    }

    private AnyMap getTermsMap(Boolean create) {
        return this.getSolrResultMap(create).getMap("terms", create.booleanValue());
    }

    private AnyMap getSpellcheckMap(Boolean create) {
        return this.getSolrResultMap(create).getMap("spellcheck", create.booleanValue());
    }

    private void setMaxScore(Number maxScore) {
        if (maxScore != null) {
            this.getSolrResultMap(true).put("max_score", maxScore);
        }
    }
}

