/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.search;

import java.net.URLDecoder;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.xml.XmlSerializationUtils;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.solr.Activator;
import org.eclipse.smila.solr.SolrManager;
import org.eclipse.smila.solr.search.SolrQueryConverter;
import org.eclipse.smila.solr.search.SolrQueryParameterAccessor;
import org.eclipse.smila.solr.search.SolrResultBuilder;

public class SolrSearchPipelet
implements Pipelet {
    protected AnyMap _configuration;
    private final Log _log = LogFactory.getLog(SolrSearchPipelet.class);
    private SolrManager _solrManager;

    public void configure(AnyMap config) throws ProcessingException {
        this._configuration = config;
    }

    public String[] process(Blackboard blackboard, String[] queryIds) throws ProcessingException {
        if (queryIds.length != 1) {
            throw new ProcessingException("number of queryIds expected to be 1 but is: " + queryIds.length);
        }
        try {
            QueryResponse solrResponse;
            String queryId = queryIds[0];
            Record record = blackboard.getRecord(queryId);
            SolrQueryParameterAccessor accessor = new SolrQueryParameterAccessor(blackboard, queryId);
            accessor.setPipeletConfiguration(this._configuration);
            String coreName = accessor.getIndexName();
            if (StringUtils.isBlank((String)coreName)) {
                this._log.info((Object)"Core/index name missing from query or is blank. Skipping search.");
                return queryIds;
            }
            SolrServer solrServer = this.getSolrManager().getSolrServer(coreName);
            ArrayList<String> schemaAttributes = new ArrayList<String>(this._solrManager.getSolrAdmin().getFieldNames(coreName));
            SolrQuery solrQuery = new SolrQueryConverter(accessor).toSolrQuery(schemaAttributes);
            if (solrQuery == null || solrQuery.getParameterNames().isEmpty()) {
                this._log.info((Object)"No query was generated. Skipping search.");
                return queryIds;
            }
            if (this._log.isDebugEnabled()) {
                String string = solrQuery.toString();
                try {
                    this._log.debug((Object)("SolrQuery URL encoded: " + solrQuery.toString()));
                    this._log.debug((Object)("SolrQuery not encoded: " + URLDecoder.decode(string, "UTF-8")));
                }
                catch (Exception exception) {}
            }
            try {
                QueryRequest queryRequest = new QueryRequest((SolrParams)solrQuery, SolrRequest.METHOD.POST);
                solrResponse = queryRequest.process(solrServer);
            }
            catch (Exception e) {
                String msg = "Error while sending solr query: " + solrQuery.toString();
                this._log.error((Object)msg, (Throwable)e);
                throw new ProcessingException(msg, (Throwable)e);
            }
            SolrResultBuilder resultBuilder = new SolrResultBuilder("SolrSearch", record, solrResponse);
            Record resultRecord = resultBuilder.processResponse();
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Result Record: " + XmlSerializationUtils.serialize2string((Record)resultRecord)));
            }
        }
        catch (Exception e) {
            this._log.error((Object)("error on processing query: " + queryIds[0]), (Throwable)e);
            throw new ProcessingException((Throwable)e);
        }
        return queryIds;
    }

    public void setSolrManager(SolrManager solrManager) {
        this._solrManager = solrManager;
    }

    public SolrManager getSolrManager() {
        if (this._solrManager == null) {
            this._solrManager = Activator.getInstance().getSolrManager();
        }
        return this._solrManager;
    }
}

