/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.v1;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.Correlation;
import org.apache.ode.bpel.compiler.v1.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.v1.PickGeneratorMessages;
import org.apache.ode.bpel.rtrep.v1.OActivity;
import org.apache.ode.bpel.rtrep.v1.OPickReceive;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OScope;
import org.apache.ode.utils.msg.MessageBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PickReceiveGenerator
extends DefaultActivityGenerator {
    protected static final CommonCompilationMessages __cmsgsGeneral = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    protected static final PickGeneratorMessages __cmsgs = (PickGeneratorMessages)MessageBundle.getMessages(PickGeneratorMessages.class);

    PickReceiveGenerator() {
    }

    @Override
    public OActivity newInstance(Activity activity) {
        return new OPickReceive(this._context.getOProcess(), this._context.getCurrent());
    }

    protected OPickReceive.OnMessage compileOnMessage(String string, String string2, String string3, String string4, QName qName, boolean bl, Collection<Correlation> collection) {
        OPickReceive.OnMessage onMessage = new OPickReceive.OnMessage(this._context.getOProcess());
        onMessage.partnerLink = this._context.resolvePartnerLink(string2);
        onMessage.operation = this._context.resolveMyRoleOperation(onMessage.partnerLink, string3);
        if (onMessage.operation.getInput() != null && onMessage.operation.getInput().getMessage() != null) {
            onMessage.variable = this._context.resolveMessageVariable(string, onMessage.operation.getInput().getMessage().getQName());
        }
        onMessage.messageExchangeId = string4;
        if (qName != null && !qName.equals(onMessage.partnerLink.myRolePortType.getQName())) {
            throw new CompilationException(__cmsgsGeneral.errPortTypeMismatch(qName, onMessage.partnerLink.myRolePortType.getQName()));
        }
        if (bl) {
            onMessage.partnerLink.addCreateInstanceOperation(onMessage.operation);
        }
        for (Correlation correlation : collection) {
            OScope.CorrelationSet correlationSet = this._context.resolveCorrelationSet(correlation.getCorrelationSet());
            switch (correlation.getInitiate()) {
                case UNSET: 
                case NO: {
                    if (bl) {
                        throw new CompilationException(__cmsgsGeneral.errUseOfUninitializedCorrelationSet(correlation.getCorrelationSet()));
                    }
                    if (onMessage.matchCorrelation != null) {
                        throw new CompilationException(__cmsgs.errSecondNonInitiateCorrelationSet(correlation.getCorrelationSet()));
                    }
                    onMessage.matchCorrelation = correlationSet;
                    onMessage.partnerLink.addCorrelationSetForOperation(onMessage.operation, correlationSet);
                    break;
                }
                case YES: {
                    onMessage.initCorrelations.add(correlationSet);
                    onMessage.partnerLink.addCorrelationSetForOperation(onMessage.operation, correlationSet);
                    onMessage.partnerLink.addUniqueCorrelationSetForOperation(onMessage.operation, correlationSet);
                    break;
                }
                case JOIN: {
                    if (bl) {
                        onMessage.partnerLink.addCorrelationSetForOperation(onMessage.operation, correlationSet);
                        onMessage.initCorrelations.add(correlationSet);
                        onMessage.matchCorrelation = correlationSet;
                        break;
                    }
                    throw new CompilationException(__cmsgs.errRendezvousNotSupported());
                }
                default: {
                    throw new AssertionError((Object)"Unexpected value for correlation set enumeration!");
                }
            }
            for (OProcess.OProperty oProperty : correlationSet.properties) {
                this._context.resolvePropertyAlias(onMessage.variable, oProperty.name);
            }
        }
        if (!onMessage.partnerLink.hasMyRole()) {
            throw new CompilationException(__cmsgsGeneral.errNoMyRoleOnReceivePartnerLink(onMessage.partnerLink.getName()));
        }
        return onMessage;
    }
}

