/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.binarystorage.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.validation.Schema;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.binarystorage.BinaryStorageException;
import org.eclipse.smila.binarystorage.BinaryStorageService;
import org.eclipse.smila.binarystorage.config.BinaryStorageConfiguration;
import org.eclipse.smila.binarystorage.internal.BinaryStorageSchemaProvider;
import org.eclipse.smila.binarystorage.persistence.BinaryPersistence;
import org.eclipse.smila.binarystorage.persistence.BinaryPersistenceFactory;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.jaxb.JaxbUtils;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;
import org.osgi.service.component.ComponentContext;

public class BinaryStorageServiceImpl
implements BinaryStorageService {
    public static final String CONFIGURATION_DIR = "configuration/";
    public static final String CONFIGURATION_FILE = "BinaryStorageConfiguration.xml";
    private static final String CONFIGURATION_BUNDLE = "org.eclipse.smila.binarystorage.impl";
    private final Log _log = LogFactory.getLog(BinaryStorageServiceImpl.class);
    private String _bundleId;
    private BinaryPersistence _bssPersistence;
    private BinaryStorageConfiguration _binaryStorageConfiguration;
    private static final String JAXB_PACKAGE = "org.eclipse.smila.binarystorage.config";

    public void store(String id, InputStream stream) throws BinaryStorageException {
        this._bssPersistence.storeBinary(id, stream);
    }

    public void store(String id, byte[] blob) throws BinaryStorageException {
        if (StringUtils.isBlank((String)id)) {
            throw new BinaryStorageException("id must not be blank");
        }
        this._bssPersistence.storeBinary(id, blob);
    }

    public byte[] fetchAsByte(String id) throws BinaryStorageException {
        return this._bssPersistence.loadBinaryAsByteArray(id);
    }

    public InputStream fetchAsStream(String id) throws BinaryStorageException {
        return this._bssPersistence.loadBinaryAsInputStream(id);
    }

    public void remove(String id) throws BinaryStorageException {
        this._bssPersistence.deleteBinary(id);
    }

    public long fetchSize(String id) throws BinaryStorageException {
        return this._bssPersistence.fetchSize(id);
    }

    protected void activate(ComponentContext context) {
        this._bundleId = context.getBundleContext().getBundle().getSymbolicName();
        try {
            this.initialize();
        }
        catch (BinaryStorageException bsex) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)bsex.getMessage());
            }
            throw new RuntimeException(bsex);
        }
    }

    protected void deactivate(ComponentContext context) throws BinaryStorageException {
        this._log.info((Object)"deactivating bundle: bin storage");
        this._bssPersistence.cleanup();
    }

    private void initialize() throws BinaryStorageException {
        this.loadBinaryStorageConfigurationProperties();
        this.setupWorkingDirectoryPath(this._binaryStorageConfiguration);
        this.initializeBSS();
    }

    private void loadBinaryStorageConfigurationProperties() throws BinaryStorageException {
        this._binaryStorageConfiguration = new BinaryStorageConfiguration();
        try {
            InputStream configurationFileStream = ConfigUtils.getConfigStream((String)CONFIGURATION_BUNDLE, (String)CONFIGURATION_FILE);
            Schema schema = BinaryStorageSchemaProvider.CONFIGURATION_SCHEMA;
            this._binaryStorageConfiguration = (BinaryStorageConfiguration)JaxbUtils.unmarshall((String)JAXB_PACKAGE, (ClassLoader)BinaryStorageConfiguration.class.getClassLoader(), (Schema)schema, (InputStream)configurationFileStream);
        }
        catch (Exception e) {
            throw new BinaryStorageException((Throwable)e, "Could not load configuration properties for " + this._bundleId + " bundle; from " + CONFIGURATION_DIR + CONFIGURATION_FILE);
        }
    }

    private void setupWorkingDirectoryPath(BinaryStorageConfiguration _binaryStorageConfiguration) throws BinaryStorageException {
        String path = _binaryStorageConfiguration.getPath();
        String tempPath = _binaryStorageConfiguration.getTempPath();
        if (StringUtils.isBlank((String)path)) {
            File file = this.buildFile();
            if (!file.exists()) {
                file.mkdir();
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Binstorage location path :" + file.getPath()));
            }
            path = file.getPath();
            if (!(file = new File(file.getParentFile(), "temp")).exists()) {
                file.mkdir();
            }
            tempPath = file.getPath();
        } else {
            tempPath = _binaryStorageConfiguration.getTempPath();
        }
        _binaryStorageConfiguration.setPath(path);
        _binaryStorageConfiguration.setTempPath(tempPath);
    }

    private File buildFile() throws BinaryStorageException {
        try {
            File file = WorkspaceHelper.createWorkingDir((String)this._bundleId);
            return new File(file, "storage");
        }
        catch (IOException ioex) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)ioex.getMessage());
            }
            throw new BinaryStorageException((Throwable)ioex, "Could not setup binary-storage working directory for " + this._bundleId + " bundle");
        }
    }

    private void initializeBSS() throws BinaryStorageException {
        this._bssPersistence = BinaryPersistenceFactory.newImplInstance(this._binaryStorageConfiguration);
    }
}

